/* korb-commander-test.cc */
/* Created by Enomoto Sanshiro on 2 March 2000. */
/* Last updated by Enomoto Sanshiro on 2 March 2000. */


#include <iostream>
#include <string>
#include <vector>
#include "MushProcess.hh"
#include "MushSignal.hh"
#include "KorbBroker.hh"
#include "KorbCommander.hh"

#include <unistd.h>

using namespace std;


int main(int argc, char **argv)
{
    vector<string> RemoteHostList;
    vector<int> DomainIdList;

    for (int i = 1; i < argc; i++) {
	RemoteHostList.push_back(string(argv[i]));
    }

    TKorbOrb Orb;
    TKorbCommander Commander(&Orb);
    try {
	Commander.Initialize();

	int RootDomainId = TKorbBroker::PrimaryDomainId();
	if (RemoteHostList.size() > 0) {
	    cout << "starting remote broker[s]..." << endl;

	    for (unsigned i = 0; i < RemoteHostList.size(); i++) {
		int DomainId = Commander.LaunchRemoteBroker(
		    RootDomainId, RemoteHostList[i]
		);
		DomainIdList.push_back(DomainId);

		cout << "  broker at " << RemoteHostList[i] << " was launched";
		cout << " with DomainId " << DomainId << "." << endl;
	    }
	}

	TMushSignalHandler SignalHandler;
	TMushSignalCounter SignalCounter;
	SignalHandler.RegisterClient(SIGTERM, &SignalCounter);
	SignalHandler.StartHandling();
	
	cout << "send SIGTERM to " << TMushProcess().ProcessId();
	cout << " to exit..." << endl;
	while (SignalCounter.SignalCount() == 0) {
	    sleep(1);
	}
	
	if (! RemoteHostList.empty()) {
	    cout << "terminating remote broker..." << endl;
	    for (unsigned j = 0; j < DomainIdList.size(); j++) {
		Commander.TerminateBroker(DomainIdList[j]);
	    }
	}

	Commander.Finalize();
	cout << "terminated." << endl;
    }
    catch (TKorbException& e) {
	cerr << "ERROR: " << e << endl;
    }

    return 0;
}
