/* logbook-client.cc */
/* Created by Enomoto Sanshiro on 23 February 2000. */
/* Last updated by Enomoto Sanshiro on 23 February 2000. */


#include <iostream>
#include "MushMisc.hh"
#include "KorbOrb.hh"
#include "LogBookOrb.hh"

using namespace std;


class TLogBookClient {
  public:
    TLogBookClient(void);
    virtual ~TLogBookClient();
    virtual void Start(void) throw(TKorbException);
  protected:
    TKorbOrb* _Orb;
    TLogBookProxy* _LogBook;
};


TLogBookClient::TLogBookClient(void)
{
    _Orb = new TKorbOrb();
    _LogBook = new TLogBookProxy(_Orb);

    if (! _LogBook->Bind("LogBook")) {
	throw TKorbException(
	    "TLogBookClient::TLogBookClient()",
	    "can't resolve reference to LogBook"
	);
    }
}

TLogBookClient::~TLogBookClient()
{
    delete _LogBook;
    delete _Orb;
}

void TLogBookClient::Start(void) throw(TKorbException)
{
    char Message[256];

    while (cout << "> " << flush, cin.getline(Message, sizeof(Message))) {
	long DateTime = TMushDateTime().AsLong();
	string Name = TMushUser().Name();

	for (int i = 0; i < 100; i++) {
	int Result = _LogBook->Write(DateTime, Name, Message);
	cout << "[" << Result << "]" << endl;
	}
    }

    cout << endl;
}


int main(int argc, char **argv)
{
    try {
	TLogBookClient().Start();
    }
    catch (TKorbException& e) {
	cerr << "ERROR: " << e << endl;
    }

    return 0;
}
