// KumaConstants.hh
// Edited by Enomoto Sanshiro on 25 February 1999.
// Last updated by Enomoto Sanshiro on 19 May 2003.


#ifndef __KumaConstants_hh
#define __KumaConstants_hh

#include "KumaUnits.hh"

namespace kuma {

// mathmatical constants //
static const double CircleRatio = 3.141592653589793238;

static const double SqrtOfTwo = 1.41421356237309;
static const double SqrtOfTwoPi = 2.506628275;


// physics constants //
static const double SpeedOfLight = 2.99792458e+8 * (m/sec);
static const double PlankConstant = 6.6260755e-34 * (Jule*sec);
static const double PlankConstantReduced = 1.05457266e-34 * (Jule*sec);
static const double ElectronChargeMagunitude = 1.602176462e-19 * (C);
static const double FineStructureConstant = 7.297352533e-3;
static const double AvogadroConstant = 6.02214199e+23;
static const double FermiCouplingConstant = 8.96199e-44 * (eV*m3);

// particle data //
static const double ElectronMass = 0.51099907 * MeV;
static const double ProtonMass = 938.27231 * MeV;
static const double NeutronMass = 939.56563 * MeV;
static const double AlphaMass = 3.727417 * GeV;

}

#endif
