/* KumaSignalProcessing.hh */
/* Created by Enomoto Sanshiro on 10 September 2004. */
/* Last updated by Enomoto Sanshiro on 12 April 2006. */


// TKumaPowerSpectrum $B$ON>B&%Q%o!<%9%Z%/%H%kL)EY$r7W;;$9$k!%(B
// double Spectrum(double Frequency) $B$N(B Frequency $B$O%5%s%W%j%s%04V3V$r(B
// $BC10L;~4V$H$9$k!%$7$?$,$C$F!$(Bfc $B$O(B 0.5 $B$KBP1~$7!$(B-0.5 <= f < 0.5 $B$,(B
// $BM-8z$JHO0O$H$J$k!%>\:Y$O(B KumaFourierTransform.hh $B$N%3%a%s%H$r;2>H!%(B


#ifndef __KumaSignalProcessing_hh__
#define __KumaSignalProcessing_hh__

#include <complex>
#include "KumaDefs.hh"
#include "KumaFunction.hh"


namespace kuma {


class TKumaPowerSpectrum: public TKumaFunction {
  public:
    TKumaPowerSpectrum(void);
    virtual ~TKumaPowerSpectrum();
    virtual void ReadData(double* DataList, int ListSize) throw(TKumaException) = 0;
    virtual double Spectrum(double Frequency) throw(TKumaException) = 0;
    virtual double Spectrum(const std::complex<double>& Frequency) throw(TKumaException) = 0;
  public:
    virtual double ValueOf(const double* InputValueList, int InputListSize);
};


class TKumaFourierTransformPowerSpectrum: public TKumaPowerSpectrum {
  public:
    TKumaFourierTransformPowerSpectrum(void);
    virtual ~TKumaFourierTransformPowerSpectrum();
    virtual void ReadData(double* DataList, int ListSize) throw(TKumaException);
    virtual double Spectrum(double Frequency) throw(TKumaException);
    virtual double Spectrum(const std::complex<double>& Frequency) throw(TKumaException);
  protected:
    int _DataListSize;
    std::complex<double>* _FourierSpectrum;
};


class TKumaMaximumEntropyPowerSpectrum: public TKumaPowerSpectrum {
  public:
    TKumaMaximumEntropyPowerSpectrum(int Order);
    virtual ~TKumaMaximumEntropyPowerSpectrum();
    virtual void ReadData(double* DataList, int ListSize) throw(TKumaException);
    virtual double Spectrum(double Frequency) throw(TKumaException);
    virtual double Spectrum(const std::complex<double>& Frequency) throw(TKumaException);
  public:
    virtual const long double* CoefficientList(void) const;
  protected:
    int _Order;
    long double* _CoefficientList;
};


class TKumaShannonInterpolatedFunction: public TKumaFunction {
  public:
    TKumaShannonInterpolatedFunction(void);
    virtual ~TKumaShannonInterpolatedFunction();
    virtual void SetData(const double* SampleList, int ListSize);
    virtual void ReadData(const double* SampleList, int ListSize);
    virtual void SetTimeLabel(double StartTime, double SampleInterval);
    virtual void RemoveTrend(void);
  public:
    virtual double ValueOf(const double* InputValueList, int InputListSize);
  protected:
    const double *_SampleList;
    int _ListSize;
    double _StartTime, _SampleInterval;
  private:
    double *_SampleListBuffer;
    TKumaFunction* _TrendFunction;
};


}

#endif
