/* MushCFileStream.cc */
/* Created by Enomoto Sanshiro on 31 August 2003. */
/* Last updated by Enomoto Sanshiro on 31 August 2003. */


#include <iostream>
#include <cstdio>
#include "MushCFileStream.hh"

using namespace std;


static const int DefaultBufferSize = 4096;


TMushCFileStreamBuffer::TMushCFileStreamBuffer(FILE* CFile)
{
    _CFile = CFile;

    _BufferSize = DefaultBufferSize;
    _Buffer = new char[_BufferSize];
    
    char* Begin = _Buffer;
    char* End = _Buffer + _BufferSize;
    setp(Begin, End);
    setg(Begin, End, End);
}

TMushCFileStreamBuffer::~TMushCFileStreamBuffer()
{
    delete[] _Buffer;
}

int TMushCFileStreamBuffer::overflow(int ch)
{
    sync();

    if (ch != EOF) {
	*pptr() = ch;
	pbump(1);
    }
    
    return ch;
}

int TMushCFileStreamBuffer::underflow(void)
{
    int Size = fread(_Buffer, sizeof(char), _BufferSize, _CFile);
    if (Size == 0) {
        return EOF;
    }
    else if (Size < 0) {
	// interrupted system call... try again //
	return underflow();
    }

    char* Begin = _Buffer;
    char* Next = _Buffer;
    char* End = _Buffer + Size;
    setg(Begin, Next, End);

    return *gptr();
}

int TMushCFileStreamBuffer::sync(void) 
{
    if (pptr() == _Buffer) {
	return 0;
    }

    int Length = pptr() - _Buffer;
    fwrite(_Buffer, sizeof(char), Length, _CFile);

    char* Begin = _Buffer;
    char* End = _Buffer + _BufferSize;
    setp(Begin, End);

    return 0;
}



TMushInputCFileStream::TMushInputCFileStream(FILE* CFile)
: istream(_StreamBuffer = new TMushCFileStreamBuffer(CFile))
{
}

TMushInputCFileStream::~TMushInputCFileStream() 
{
    delete _StreamBuffer;
}

TMushCFileStreamBuffer* TMushInputCFileStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}


TMushOutputCFileStream::TMushOutputCFileStream(FILE* CFile)
: ostream(_StreamBuffer = new TMushCFileStreamBuffer(CFile))
{
}

TMushOutputCFileStream::~TMushOutputCFileStream() 
{
    delete _StreamBuffer;
}

TMushCFileStreamBuffer* TMushOutputCFileStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}
