/* MushChainedFile.hh */
/* Created by Enomoto Sanshiro on 3 March 1998. */
/* Last updated by Enomoto Sanshiro on 30 April 2002. */


#ifndef __MushChainedFile_hh__
#define __MushChainedFile_hh__

#include <string>
#include <map>
#include "MushDefs.hh"
#include "MushFile.hh"
#include "MushFileSystem.hh"



class TMushChainedFile: public TMushFile {
  public:
    TMushChainedFile(const std::string& FileName, unsigned MaxFileSize = 0x10000000, unsigned MinimumTailPacketSize = 0);
    virtual ~TMushChainedFile();
    virtual void OpenReadMode(void) throw(TSystemCallException);
    virtual void OpenWriteMode(unsigned AccessMode = 0644, bool IsExclusive = false) throw(TSystemCallException);
    virtual void OpenAppendMode(unsigned AccessMode = 0644) throw(TSystemCallException);
    virtual void OpenReadWriteMode(unsigned AccessMode = 0644) throw(TSystemCallException);
    virtual int Read(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual int Write(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual mush::Int64 Position(void) throw(TSystemCallException);
    virtual void SeekTo(mush::Int64 Offset) throw(TSystemCallException);
    virtual void SeekBy(mush::Int64 Offset) throw(TSystemCallException);
    virtual void Unlink(void) throw(TSystemCallException);
    virtual long Size(void) const throw(TSystemCallException);
  protected:
    virtual void Open(int OpenFlag, unsigned AccessMode) throw(TSystemCallException);
    virtual std::string FileNameOf(unsigned FileIndex);
    virtual mush::Int64 FileSizeOf(unsigned FileIndex) throw(TSystemCallException);
    virtual int MoveTo(unsigned FileIndex, mush::Int64 FileHeadOffset) throw(TSystemCallException);
    virtual int MoveToNext(void) throw(TSystemCallException);
    virtual int MoveToPrevious(void) throw(TSystemCallException);
    virtual int MoveToFirst(void) throw(TSystemCallException);
  protected:
    unsigned _MaxFileSize, _MinimumTailPacketSize;
    unsigned _ThisFileIndex;
    unsigned _LastPacketSize;
    mush::Int64 _ThisFileHeadOffset;
    mush::Int64 _PositionInThisFile;
    int _OpenFlag;
    unsigned _AccessMode;
    bool _IsReadMode;
  private:
    std::map<unsigned, std::string> _FileNameCacheTable;
    std::map<unsigned, mush::Int64> _FileSizeCacheTable;
};


class TMushChainedFileAttribute: public TMushFileAttribute {
  public:
    TMushChainedFileAttribute(const std::string& FilePathName);
    virtual ~TMushChainedFileAttribute();
    virtual long Size(void) throw(TSystemCallException);
};


#endif
