/* MushCheckSum.hh */
/* Created by Enomoto Sanshiro on 15 February 2002. */
/* Last updated by Enomoto Sanshiro on 15 February 2002. */


#ifndef __MushCheckSum_hh__
#define __MushCheckSum_hh__

#include "MushConfig.hh"


class TMushCheckSum {
  public:
    TMushCheckSum(void) {}
    virtual ~TMushCheckSum() {}
    virtual void ReadData(const char* Data, unsigned long Size) = 0;
    virtual unsigned long DataLength(void) = 0;
    virtual unsigned ResultLength(void) = 0;
    virtual unsigned char ByteValueAt(unsigned Index) = 0;
    unsigned char operator[](unsigned Index) { return ByteValueAt(Index); }
};


class TMushCrc32CheckSum: public TMushCheckSum {
  public:
    TMushCrc32CheckSum(void);
    virtual ~TMushCrc32CheckSum();
    virtual void ReadData(const char* Data, unsigned long Size);
    virtual unsigned long DataLength(void);
    virtual unsigned ResultLength(void);
    virtual unsigned char ByteValueAt(unsigned Index);
  protected:
    static mush::UInt32 _CrcTable[256];
    static bool _IsCrcTableComputed;
    mush::UInt32 _CrcValue;
    unsigned long _DataLength;
};


class TMushMd5CheckSum: public TMushCheckSum {
};


#endif
