/* MushConsoleStream.hh */
/* Created by Enomoto Sanshiro on 14 May 2000. */
/* Last updated by Enomoto Sanshiro on 14 May 2000. */


#ifndef __MushConsoleStream_hh__
#define __MushConsoleStream_hh__

#include <iostream>
#include <cstdio>
#include "MushConsole.hh"


class TMushConsoleStreamBuffer: public std::streambuf {
  public:
    TMushConsoleStreamBuffer(TMushConsole* Console);
    virtual ~TMushConsoleStreamBuffer();
  protected:
    virtual int overflow(int ch = EOF);
    virtual int underflow(void);
    virtual int sync(void);
  private:
    TMushConsole* _Console;
    char *_Buffer;
    int _BufferSize;
};


class TMushInputConsoleStream: public std::istream {
  public:
    TMushInputConsoleStream(TMushConsole* Console);
    virtual ~TMushInputConsoleStream();
    virtual TMushConsoleStreamBuffer* rdbuf(void);
  private:
    TMushConsoleStreamBuffer* _StreamBuffer;
};


class TMushOutputConsoleStream: public std::ostream {
  public:
    TMushOutputConsoleStream(TMushConsole* Console);
    virtual ~TMushOutputConsoleStream();
    virtual TMushConsoleStreamBuffer* rdbuf(void);
  private:
    TMushConsoleStreamBuffer* _StreamBuffer;
};


#endif
