/* MushDataCompressor.hh */
/* Created by Enomoto Sanshiro on 29 January 2002. */
/* Last updated by Enomoto Sanshiro on 29 January 2002. */


#ifndef __MushDataCompressor_hh__
#define __MushDataCompressor_hh__

#include "MushDefs.hh"


class TMushDataCompressor {
  public:
    TMushDataCompressor(void);
    virtual ~TMushDataCompressor(void);
    virtual void SetCompressInput(void* InputData, size_t InputDataSize, bool IsLast) = 0;
    virtual void SetDecompressInput(void* InputData, size_t InputDataSize, bool IsLast) = 0;
    virtual int Compress(void* Buffer, size_t BufferSize) = 0;
    virtual int Decompress(void* Buffer, size_t BufferSize) = 0;
};



#if USE_ZLIB
#include <zlib.h>

class TMushZlibDataCompressor: public TMushDataCompressor {
  public:
    TMushZlibDataCompressor(int CompressionLevel = 1);
    virtual ~TMushZlibDataCompressor();
    virtual void SetCompressInput(void* InputData, size_t InputDataSize, bool IsLast);
    virtual void SetDecompressInput(void* InputData, size_t InputDataSize, bool IsLast);
    virtual int Compress(void* Buffer, size_t BufferSize);
    virtual int Decompress(void* Buffer, size_t BufferSize);
  protected:
    z_stream* _InflateZ;
    z_stream* _DeflateZ;
    int _CompressionLevel;
    bool _IsLastData;
    bool _IsLastDataProcessed;
};

#else

class TMushZlibDataCompressor: public TMushDataCompressor {
  public:
    TMushZlibDataCompressor(int CompressionLevel = 1);
    virtual ~TMushZlibDataCompressor();
    virtual void SetCompressInput(void* InputData, size_t InputDataSize, bool IsLast);
    virtual void SetDecompressInput(void* InputData, size_t InputDataSize, bool IsLast);
    virtual int Compress(void* Buffer, size_t BufferSize);
    virtual int Decompress(void* Buffer, size_t BufferSize);
};

#endif

#endif
