/* MushDataEncoder.cc */
/* Created by Enomoto Sanshiro on 23 January 2000. */
/* Last updated by Enomoto Sanshiro on 28 January 2002. */


#include <cstring>
#include "MushDataEncoder.hh"

#if USE_ZLIB
#include <zlib.h>
#endif


using namespace std;


TMushDataEncoder::TMushDataEncoder(void)
{
}

TMushDataEncoder::~TMushDataEncoder()
{
}



TMushBinaryDataEncoder::TMushBinaryDataEncoder(size_t WordSize, bool ReverseBytes)
{
    _WordSize = WordSize;
    _ReverseBytes = ReverseBytes;
}

TMushBinaryDataEncoder::~TMushBinaryDataEncoder()
{
}

size_t TMushBinaryDataEncoder::Encode(void* Data, size_t DataSize, void*& Result, size_t& ResultSize) throw(TSystemCallException)
{
    if (_ReverseBytes) {
	ConvertData(Data, DataSize);
    }
    else {
        Result = Data;
    }
    ResultSize = DataSize;

    return DataSize;
}

size_t TMushBinaryDataEncoder::Decode(void* Data, size_t DataSize, void*& Result, size_t& ResultSize) throw(TSystemCallException)
{
    if (_ReverseBytes) {
	ConvertData(Data, DataSize);
    }
    else {
        Result = Data;
    }
    ResultSize = DataSize;

    return DataSize;
}

size_t TMushBinaryDataEncoder::EncodeOn(void* Data, size_t DataSize) throw(TSystemCallException)
{
    if (_ReverseBytes) {
	ConvertData(Data, DataSize);
    }

    return DataSize;
}

size_t TMushBinaryDataEncoder::DecodeOn(void* Data, size_t DataSize) throw(TSystemCallException)
{
    if (_ReverseBytes) {
	ConvertData(Data, DataSize);
    }

    return DataSize;
}

size_t TMushBinaryDataEncoder::ConvertData(void* Data, size_t Size)
{
    char* ByteData = (char*) Data;
    size_t Index, NextIndex;
    size_t ByteOffset;
    int Byte1, Byte2;
    
    for (Index = 0; Index < Size; Index += _WordSize) {
        NextIndex = Index + _WordSize;
	
	for (ByteOffset = 0; ByteOffset < _WordSize / 2; ByteOffset++) {
	    Byte1 = ByteData[Index + ByteOffset];
	    Byte2 = ByteData[NextIndex - (ByteOffset + 1)];
	    ByteData[Index + ByteOffset] = Byte2;
	    ByteData[NextIndex - (ByteOffset + 1)] = Byte1;
	}
    }

    return Size;
}



#if USE_ZLIB

TMushZlibDataEncoder::TMushZlibDataEncoder(int CompressionLevel)
{
    _CompressionLevel = CompressionLevel;

    _BufferSize = 4096;
    _Buffer = new char[_BufferSize];

#if 0
    _DeflateZ.zalloc = Z_NULL;
    _DeflateZ.zfree = Z_NULL;
    _DeflateZ.opaque = Z_NULL;
    if (deflateInit(&_DeflateZ, CompressionLevel) != Z_OK) {
	throw TSystemCallException(
	    "TMushZlibDataEncoder::TMushZlibDataEncoder()",
	    _DeflateZ.msg
	);
    }

    _InflateZ.zalloc = Z_NULL;
    _InflateZ.zfree = Z_NULL;
    _InflateZ.opaque = Z_NULL;
    if (inflateInit(&_InflateZ) != Z_OK) {
	throw TSystemCallException(
	    "TMushZlibDataEncoder::TMushZlibDataEncoder()",
	    _InflateZ.msg
	);
    }
#endif
}

TMushZlibDataEncoder::~TMushZlibDataEncoder()
{
#if 0
    deflateEnd(&_DeflateZ);
    inflateEnd(&_InflateZ);
#endif

    delete[] _Buffer;
}

void TMushZlibDataEncoder::ReallocateBuffer(size_t NewSize, size_t DataSizeInBuffer)
{
    char* OldBuffer = _Buffer;

    _BufferSize = NewSize;
    _Buffer = new char[_BufferSize];

    if (DataSizeInBuffer > 0) {
	memcpy(_Buffer, OldBuffer, DataSizeInBuffer);
    }

    delete[] OldBuffer;
}

size_t TMushZlibDataEncoder::Encode(void* Data, size_t DataSize, void*& Result, size_t& ResultSize) throw(TSystemCallException)
{
    if (_BufferSize < DataSize) {
	ReallocateBuffer(2 * DataSize);
    }

#if 1
    _DeflateZ.zalloc = Z_NULL;
    _DeflateZ.zfree = Z_NULL;
    _DeflateZ.opaque = Z_NULL;
    if (deflateInit(&_DeflateZ, _CompressionLevel) != Z_OK) {
	throw TSystemCallException(
	    "TMushZlibDataEncoder::TMushZlibDataEncoder()",
	    "deflateInit(): " + string(_DeflateZ.msg)
	);
    }
#endif

    ResultSize = 0;
    size_t OutputBufferSize = _BufferSize;

    _DeflateZ.next_in = (Bytef*) Data;
    _DeflateZ.avail_in = DataSize;
    _DeflateZ.next_out = (Bytef*) _Buffer;
    _DeflateZ.avail_out = OutputBufferSize;

    int Status;
    while ((Status = deflate(&_DeflateZ, Z_FINISH)) == Z_OK) {
	ResultSize += OutputBufferSize - _DeflateZ.avail_out;
	ReallocateBuffer(2 * _BufferSize, ResultSize);
	OutputBufferSize = _BufferSize - ResultSize;

	_DeflateZ.next_out = (Bytef*) _Buffer + ResultSize;
	_DeflateZ.avail_out = OutputBufferSize;
    }

    if (Status != Z_STREAM_END) {
	throw TSystemCallException(
	    "TMushZlibDataEncoder::Encode()", 
	    "deflate(): " + string(_DeflateZ.msg)
	);
    }

    Result = _Buffer;
    ResultSize += OutputBufferSize - _DeflateZ.avail_out;

#if 1
    deflateEnd(&_DeflateZ);
#endif

    return DataSize;
}

size_t TMushZlibDataEncoder::Decode(void* Data, size_t DataSize, void*& Result, size_t& ResultSize) throw(TSystemCallException)
{
    if (_BufferSize < 4 * DataSize) {
	ReallocateBuffer(6 * DataSize);
    }

#if 1
    _InflateZ.zalloc = Z_NULL;
    _InflateZ.zfree = Z_NULL;
    _InflateZ.opaque = Z_NULL;
    if (inflateInit(&_InflateZ) != Z_OK) {
	throw TSystemCallException(
	    "TMushZlibDataEncoder::TMushZlibDataEncoder()",
	    "inflateInit(): " + string(_InflateZ.msg)
	);
    }
#endif

    ResultSize = 0;
    size_t OutputBufferSize = _BufferSize;

    _InflateZ.next_in = (Bytef*) Data;
    _InflateZ.avail_in = DataSize;
    _InflateZ.next_out = (Bytef*) _Buffer;
    _InflateZ.avail_out = OutputBufferSize;

    int Status;
    while ((Status = inflate(&_InflateZ, Z_NO_FLUSH)) == Z_OK) {
	ResultSize += OutputBufferSize - _InflateZ.avail_out;
	ReallocateBuffer(4 * _BufferSize, ResultSize);
	OutputBufferSize = _BufferSize - ResultSize;

	_InflateZ.next_out = (Bytef*) _Buffer + ResultSize;
	_InflateZ.avail_out = OutputBufferSize;
    }

    if (Status != Z_STREAM_END) {
	throw TSystemCallException(
	    "TMushZlibDataEncoder::Decode()", 
	    "inflate(): " + string(_InflateZ.msg)
	);
    }

    Result = _Buffer;
    ResultSize += OutputBufferSize - _InflateZ.avail_out;

#if 1
    inflateEnd(&_InflateZ);
#endif

    return 0;
}

#endif
