/* MushDefs.cc */
/* Created by Enomoto Sanshiro on 18 November 1997. */
/* Last updated by Enomoto Sanshiro on 18 Febuary 1998. */


#include <iostream>
#include <string>
#include <cerrno>
#include <sys/types.h>
#include "MushDefs.hh"


using namespace std;


TSystemCallException::TSystemCallException(string Location) 
{
    _ErrorNumber = errno;
    _Message = Location + string(": ") + string(strerror(_ErrorNumber));
}

TSystemCallException::TSystemCallException(string Location, int ErrorNumber)
{
    _ErrorNumber = ErrorNumber;
    _Message = Location + string(": ") + string(strerror(_ErrorNumber));
}

TSystemCallException::TSystemCallException(string Location, string Message) 
{
    _ErrorNumber = 0;
    _Message = Location;

    if (! Message.empty()) {
        _Message += string(": ") + Message;
    }
}

TSystemCallException::TSystemCallException(const TSystemCallException &e) 
{
    _ErrorNumber = e._ErrorNumber;
    _Message = e._Message;
}    

ostream& operator<< (ostream &os, const TSystemCallException &e)
{
    return os << e.Message();
}

int TSystemCallException::ErrorNumber(void) const 
{
    return _ErrorNumber;
}

string TSystemCallException::Message(void) const 
{
    return _Message;
}

int TSystemCallException::operator== (int ErrorNumber) const 
{
    return (_ErrorNumber == ErrorNumber);
}
