/* MushFile.hh */
/* Created by Enomoto Sanshiro on 3 March 1998. */
/* Last updated by Enomoto Sanshiro on 30 April 2002. */


#ifndef __MushFile_hh__
#define __MushFile_hh__

#include <string>
#include "MushConfig.hh"
#include "MushDefs.hh"


class TMushFile {
  public:
    TMushFile(const std::string& FileName);
    TMushFile(int FileDescriptor);
    virtual ~TMushFile();
    virtual void OpenReadMode(void) throw(TSystemCallException);
    virtual void OpenWriteMode(unsigned AccessMode = 0644, bool IsExclusive = false) throw(TSystemCallException);
    virtual void OpenAppendMode(unsigned AccessMode = 0644) throw(TSystemCallException);
    virtual void OpenReadWriteMode(unsigned AccessMode = 0644) throw(TSystemCallException);
    virtual void Close(void);
    virtual int Read(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual int Write(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual mush::Int64 Position(void) throw(TSystemCallException);
    virtual void SeekTo(mush::Int64 Offset) throw(TSystemCallException);
    virtual void SeekBy(mush::Int64 Offset) throw(TSystemCallException);
    virtual void Unlink(void) throw(TSystemCallException);
    virtual std::string Name(void) const;
    virtual long Size(void) const throw(TSystemCallException);
    virtual bool IsOpened(void) const;
    virtual int FileDescriptor(void) const;
  public:
    virtual int ReadBlock(void *Buffer, size_t Length, bool IsPatient = false) throw(TSystemCallException);
    virtual int WriteBlock(void *Buffer, size_t Length) throw(TSystemCallException);
  protected:
    virtual void Open(int OpenFlag, unsigned AccessMode) throw(TSystemCallException);
  protected:
    std::string _Name;
    int _FileDescriptor;
  private:
    int _MyFileDescriptor;
};


class TMushLockFile {
  public:
    TMushLockFile(std::string Name);
    virtual ~TMushLockFile();
    virtual std::string Name(void) const;
    virtual bool Lock(unsigned AccessMode = 0664);
    virtual void Unlock(void);
  protected:
    TMushFile _File;
    bool _IsLocked;
};

#endif
