/* MushFileStream.hh */
/* Created by Enomoto Sanshiro on 7 August 2003. */
/* Last updated by Enomoto Sanshiro on 7 August 2003. */


#ifndef __MushFileStream_hh__
#define __MushFileStream_hh__

#include <iostream>
#include <cstdio>
#include "MushFile.hh"


class TMushFileStreamBuffer: public std::streambuf {
  public:
    TMushFileStreamBuffer(TMushFile* File);
    virtual ~TMushFileStreamBuffer();
  protected:
    virtual int overflow(int ch = EOF);
    virtual int underflow(void);
    virtual int sync(void);
  private:
    TMushFile* _File;
    char *_Buffer;
    int _BufferSize;
};


class TMushInputFileStream: public std::istream {
  public:
    TMushInputFileStream(TMushFile* File);
    virtual ~TMushInputFileStream();
    virtual TMushFileStreamBuffer* rdbuf(void);
  private:
    TMushFileStreamBuffer* _StreamBuffer;
};


class TMushOutputFileStream: public std::ostream {
  public:
    TMushOutputFileStream(TMushFile* File);
    virtual ~TMushOutputFileStream();
    virtual TMushFileStreamBuffer* rdbuf(void);
  private:
    TMushFileStreamBuffer* _StreamBuffer;
};


#endif
