/* MushFramedFile.hh */
/* Created by Enomoto Sanshiro on 25 October 1999. */
/* Last updated by Enomoto Sanshiro on 30 April 2002. */


#ifndef __MushFramedFile_hh__
#define __MushFramedFile_hh__

#include <string>
#include "MushFile.hh"
#include "MushDecoratedFile.hh"



class TMushFramedFileIndex;

class TMushFramedFile: public TMushDecoratedFile {
  public:
    TMushFramedFile(TMushFile *ComponentFile, bool IsIndexEnabled = false);
    virtual ~TMushFramedFile();
    virtual void OpenReadMode(void) throw(TSystemCallException);
    virtual void OpenWriteMode(unsigned AccessMode = 0644, bool IsExclusive = false) throw(TSystemCallException);
    virtual void OpenAppendMode(unsigned AccessMode = 0644) throw(TSystemCallException);
    virtual void OpenReadWriteMode(unsigned AccessMode = 0644) throw(TSystemCallException);
    virtual void Close(void);
    virtual int Read(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual int Write(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual mush::Int64 Position(void) throw(TSystemCallException);
    virtual void SeekTo(mush::Int64 Offset) throw(TSystemCallException);
    virtual void SeekBy(mush::Int64 Offset) throw(TSystemCallException);
    virtual long Size(void) const throw(TSystemCallException);
  public:
    virtual int NextPacketSize(void) throw(TSystemCallException);
    virtual int SkipNext(void) throw(TSystemCallException);
  protected:
    enum {
	_HeaderSize = 4,
	_IndexWidth = 8
    };
  protected:
    mutable TMushFramedFileIndex* _Index;
    mush::UInt64 _CurrentPosition;
    mush::UInt8 _HeaderBuffer[_HeaderSize];
    int _NextPacketSize;
    bool _IsIndexEnabled;
    bool _IsReadMode;
};


class TMushFramedFileIndex {
  public:
    typedef mush::UInt64 TFileOffset;
  public:
    TMushFramedFileIndex(const TMushFramedFile* FramedFile);
    virtual ~TMushFramedFileIndex();
    virtual void OpenWriteMode(int AccessMode) throw(TSystemCallException);
    virtual void OpenReadMode(void) throw(TSystemCallException);
    virtual void Close(void) throw(TSystemCallException);
    virtual void AddNext(TFileOffset Offset, size_t Size) throw(TSystemCallException);
    virtual TFileOffset OffsetOf(mush::UInt64 Index) throw(TSystemCallException);
    virtual mush::UInt64 NumberOfPackets(void) const;
    virtual mush::UInt64 MaxPacketSize(void) const;
  protected:
    virtual void WritePreamble(void) throw(TSystemCallException);
    virtual void ReadPreamble(void) throw(TSystemCallException);
  protected:
    std::string _FileName;
    TMushFile* _IndexFile;
    mush::UInt8* _Buffer;
    size_t _BufferSize;
    size_t _BufferIndex;
    mush::UInt64 _CurrentIndex;
    size_t _CurrentOffsetLength;
    mush::UInt64 _CurrentOffsetMax;
  protected:
    mush::UInt64 _FormatFlags;
    mush::UInt64 _NumberOfPackets;
    mush::UInt64 _MaxPacketSize;
    mush::UInt64 _ShortOffsetStartIndex;
    mush::UInt64 _ShortOffsetBase;
    mush::UInt64 _MediumOffsetStartIndex;
    mush::UInt64 _MediumOffsetBase;
    mush::UInt64 _LongOffsetStartIndex;
    mush::UInt64 _LongOffsetBase;
  protected:
    enum TPreambleOffsets {
	MagicNumberOffset,
	VersionOffset,
	FormatFlagsOffset,
	NumberOfPacketsOffset,
	MaxPacketSizeOffset,
	ShortOffsetStartIndexOffset,
	ShortOffsetBaseOffset,
	MediumOffsetStartIndexOffset,
	MediumOffsetBaseOffset,
	LongOffsetStartIndexOffset,
	LongOffsetBaseOffset,
	_NumberOfPreambleWords
    };
};


#endif
