/* MushJunks.cc */
/* Created by Enomoto Sanshiro on 28 May 1998. */
/* Last updated by Enomoto Sanshiro on 9 December 2000. */


#include <iostream>
#include "MushJunks.hh"

using namespace std;


TMushProgressBar::TMushProgressBar(ostream &os, unsigned AdvanceStep)
: _OutStream(os) 
{
    _Step = 0;
    _Length = 0;
    _AdvanceStep = AdvanceStep;
    _MaxLength = 80;
}

TMushProgressBar::~TMushProgressBar() 
{
}

void TMushProgressBar::Start(const string& Header)
{
    _OutStream << Header << ' ';
    _Length += Header.size();
}

void TMushProgressBar::Clear(void)
{
    _OutStream << '\r';
    for (unsigned i = 0; i < _Length + 1; i++) {
	_OutStream << ' ';
    }
    _OutStream << '\r' << flush;

    _Step = 0;
    _Length = 0;
}

void TMushProgressBar::Next(void)
{
    static const char *Bars[] = {"\b|", "\b/", "\b-", "\b\\"};
    _OutStream << Bars[(_Step + 1) % 4] << flush;
    if ((++_Step > _AdvanceStep) && (_AdvanceStep > 0)) {
	Advance();
	_Step = 0;
    }
}

void TMushProgressBar::Advance(void) 
{
    if (_Length < _MaxLength) { 
	_OutStream << "\b. " << flush;
	_Length++;
    }
}
