/* MushSocketStream.hh */
/* Created by Enomoto Sanshiro on 14 May 2000. */
/* Last updated by Enomoto Sanshiro on 26 June 2009. */


#ifndef __MushSocketStream_hh__
#define __MushSocketStream_hh__

#include <iostream>
#include <cstdio>
#include "MushSocket.hh"


class TMushSocketStreamBuffer: public std::streambuf {
  public:
    TMushSocketStreamBuffer(TMushSocket* Socket);
    virtual ~TMushSocketStreamBuffer();
  protected:
    virtual int overflow(int ch = EOF);
    virtual int underflow(void);
    virtual int sync(void);
  private:
    TMushSocket* _Socket;
    char *_InputBuffer, *_OutputBuffer;
    int _BufferSize;
};


class TMushInputSocketStream: public std::istream {
  public:
    TMushInputSocketStream(TMushSocket* Socket);
    virtual ~TMushInputSocketStream();
    virtual TMushSocketStreamBuffer* rdbuf(void);
  private:
    TMushSocketStreamBuffer* _StreamBuffer;
};


class TMushOutputSocketStream: public std::ostream {
  public:
    TMushOutputSocketStream(TMushSocket* Socket);
    virtual ~TMushOutputSocketStream();
    virtual TMushSocketStreamBuffer* rdbuf(void);
  private:
    TMushSocketStreamBuffer* _StreamBuffer;
};


class TMushInputOutputSocketStream: public std::iostream {
  public:
    TMushInputOutputSocketStream(TMushSocket* Socket);
    virtual ~TMushInputOutputSocketStream();
    virtual TMushSocketStreamBuffer* rdbuf(void);
  private:
    TMushSocketStreamBuffer* _StreamBuffer;
};


#endif
