/* MushThread.hh */
/* Created by Enomoto Sanshiro on 13 August 1998. */
/* Last updated by Enomoto Sanshiro on 13 October 2001. */


#ifndef __MushThread_hh__
#define __MushThread_hh__


#include <pthread.h>
#include "MushDefs.hh"


class TMushRunnable {
  public:
    TMushRunnable(void);
    virtual ~TMushRunnable();
    virtual void Run(void) = 0;
  protected:
    void Exit(void* ExitStatus = 0);
    void TestCancel(void);
    void EnableCancel(void);
    void DisableCancel(void);
    void EnableAsynchronousCancel(void);
    void DisableAsynchronousCancel(void);
};


class TMushThread: public TMushRunnable {
  public:
    TMushThread(TMushRunnable* Runnable);
    TMushThread(TMushRunnable& Runnable);
  protected:
    TMushThread(void);
  public:
    virtual ~TMushThread();
    virtual void Run(void) {}
    void Start(void) throw(TSystemCallException);
    long Join(void) throw(TSystemCallException);
    void Detach(void) throw(TSystemCallException);
    void Cancel(void) throw(TSystemCallException);
  private:
    pthread_t _ThreadObject;
    pthread_attr_t _Attribute;
    TMushRunnable* _Runnable;
};


class TMushThreadMutex {
  public:
    TMushThreadMutex(void);
    TMushThreadMutex(const TMushThreadMutex& Mutex);
    TMushThreadMutex& operator=(const TMushThreadMutex& Mutex);
    virtual ~TMushThreadMutex();
    void Lock(void) throw(TSystemCallException);
    bool TryLock(void) throw(TSystemCallException);
    void Unlock(void) throw(TSystemCallException);
  protected:
    pthread_mutex_t* _MutexObject;
};


class TMushThreadCondition: public TMushThreadMutex {
  public:
    TMushThreadCondition(void);
    TMushThreadCondition(const TMushThreadCondition& Condition);
    TMushThreadCondition& operator=(const TMushThreadCondition& Condition);
    virtual ~TMushThreadCondition();
    void Wait(void) throw(TSystemCallException);
    void TimedWait(long Sec, long NSec = 0) throw(TSystemCallException);
    void Signal(void) throw(TSystemCallException);
    void Broadcast(void) throw(TSystemCallException);
  protected:
    pthread_cond_t* _ConditionObject;
};


#endif
