/* compressed-file-stream-test.cc */
/* Created by Enomoto Sanshiro on 7 August 2003. */
/* Last updated by Enomoto Sanshiro on 7 August 2003. */


#include <iostream>
#include <string>
#include "MushDataCompressor.hh"
#include "MushDecoratedFile.hh"
#include "MushFileStream.hh"

using namespace std;


void Compress(const string& OutputFileName) throw (TSystemCallException)
{
    TMushDataCompressor* DataCompressor = new TMushZlibDataCompressor();

    TMushFile* OutputRawFile = new TMushFile(OutputFileName);
    TMushFile* OutputFile = new TMushCompressedFile(
	OutputRawFile, DataCompressor
    );

    OutputFile->OpenWriteMode();
    ostream* OutputStream = new TMushOutputFileStream(OutputFile);

    *OutputStream << "this is a test compressed file" << endl;
    for (int i = 0; i < 10; i++) {
	*OutputStream << i << " " << i/2.0 << endl;
    }

    delete OutputStream;
    OutputFile->Close();

    delete OutputFile;
    delete DataCompressor;
}


void Decompress(const string& InputFileName) throw (TSystemCallException)
{
    TMushDataCompressor* DataCompressor = new TMushZlibDataCompressor();

    TMushFile* InputRawFile = new TMushFile(InputFileName);
    TMushFile* InputFile = new TMushCompressedFile(
	InputRawFile, DataCompressor
    );

    InputFile->OpenReadMode();
    istream* InputStream = new TMushInputFileStream(InputFile);
    
    string Line;
    while (getline(*InputStream, Line)) {
	cout << Line << endl;
    }

    delete InputStream;
    InputFile->Close();

    delete InputFile;
    delete DataCompressor;
}


void ShowUsage(void)
{
    cerr << "usage: compressed-file-test flag file" << endl;
    cerr << "flag: " << endl;
    cerr << "  -c: compress" << endl;
    cerr << "  -d: decompress" << endl;
}


int main(int argc, char** argv)
{
    if (argc != 3) {
	ShowUsage();
	return 0;
    }

    const char* FileName = argv[2];

    try {
	if (string(argv[1]) == "-c") {
	    Compress(FileName);
	}
	else if (string(argv[1]) == "-d") {
	    Decompress(FileName);
	}
	else {
	    ShowUsage();
	}
    }
    catch (TSystemCallException &e) {
	cerr << "ERROR: " << e << endl;
    }

    return 0;
}
