/* compressed-file-test.cc */
/* Created by Enomoto Sanshiro on 31 January 2002. */
/* Last updated by Enomoto Sanshiro on 31 January 2002. */


#include <iostream>
#include <fstream>
#include <string>
#include "MushDataCompressor.hh"
#include "MushDecoratedFile.hh"

using namespace std;


void Compress(const string& InputFileName, const string& OutputFileName) throw (TSystemCallException)
{
    TMushDataCompressor* DataCompressor = new TMushZlibDataCompressor();

    TMushFile* InputFile = new TMushFile(InputFileName);
    TMushFile* OutputRawFile = new TMushFile(OutputFileName);

    TMushFile* OutputFile = new TMushCompressedFile(
	OutputRawFile, DataCompressor
    );

    InputFile->OpenReadMode();
    OutputFile->OpenWriteMode();

    static const size_t BufferSize = 4096;
    static char Buffer[BufferSize];
    int DataSize;

    while ((DataSize = InputFile->Read(Buffer, BufferSize)) > 0) {
	OutputFile->Write(Buffer, DataSize);
    }

    InputFile->Close();
    OutputFile->Close();

    delete InputFile;
    delete OutputFile;
    delete DataCompressor;
}


void Decompress(const string& InputFileName, const string& OutputFileName) throw (TSystemCallException)
{
    TMushDataCompressor* DataCompressor = new TMushZlibDataCompressor();

    TMushFile* InputRawFile = new TMushFile(InputFileName);
    TMushFile* OutputFile = new TMushFile(OutputFileName);
    TMushFile* InputFile = new TMushCompressedFile(
	InputRawFile, DataCompressor
    );

    InputFile->OpenReadMode();
    OutputFile->OpenWriteMode();

    static const size_t BufferSize = 4096;
    static char Buffer[BufferSize];
    int DataSize;

    while ((DataSize = InputFile->Read(Buffer, BufferSize)) > 0) {
	OutputFile->Write(Buffer, DataSize);
    }

    InputFile->Close();
    OutputFile->Close();

    delete InputFile;
    delete OutputFile;
    delete DataCompressor;
}


void ShowUsage(void)
{
    cerr << "usage: compressed-file-test flag infile outfile" << endl;
    cerr << "flag: " << endl;
    cerr << "  -c: compress" << endl;
    cerr << "  -d: decompress" << endl;
}


int main(int argc, char** argv)
{
    if (argc != 4) {
	ShowUsage();
	return 0;
    }

    const char* InputFileName = argv[2];
    const char* OutputFileName = argv[3];

    try {
	if (string(argv[1]) == "-c") {
	    Compress(InputFileName, OutputFileName);
	}
	else if (string(argv[1]) == "-d") {
	    Decompress(InputFileName, OutputFileName);
	}
	else {
	    ShowUsage();
	}
    }
    catch (TSystemCallException &e) {
	cerr << "ERROR: " << e << endl;
    }

    return 0;
}
