/* message-queue-test.cc */
/* Created by Enomoto Sanshiro on 5 May 2000. */
/* Last updated by Enomoto Sanshiro on 5 May 2000. */


#include <iostream>
#include <cstring>
#include "MushSignal.hh"
#include "MushIpc.hh"

using namespace std;


static const int ProjectID = 123;
static const int ServerMessageAddress = 1;
static const int BufferSize = 256;
static char Buffer[BufferSize];


void WorkAsClient(TMushMessageQueue* MessageQueue) throw(TSystemCallException)
{
    TMushMessageQueuePacket* Packet = (TMushMessageQueuePacket*) Buffer;
    Packet->MessageType = ServerMessageAddress;
    char* Message = (char*) &(Packet->MessageText);

    while (
	cout << "Message> " << flush, 
	cin.getline(Message, BufferSize, '\n')
    ){
	int MessageLength = sizeof(TMushMessageQueuePacket) + strlen(Message) + 1;
	MessageQueue->Send(Packet, MessageLength);
    }
}


void WorkAsServer(TMushMessageQueue* MessageQueue) throw(TSystemCallException)
{
    TMushSignalHandler SignalHandler;
    TMushSignalCounter ExitSignalCounter;
    SignalHandler.RegisterClient(SIGINT, &ExitSignalCounter);
    SignalHandler.StartHandling();
    cout << "Send SIGINT (press C-c) to exit..." << endl;

    TMushMessageQueuePacket* Packet = (TMushMessageQueuePacket*) Buffer;
    MessageQueue->SetAddress(ServerMessageAddress);
    char* Message = (char*) &(Packet->MessageText);

    while (ExitSignalCounter.SignalCount() == 0) {
	int MaxLength = BufferSize;
	int ReceivedLength = MessageQueue->Receive(Packet, MaxLength);

	if (ReceivedLength > 0) {
	    cout << Message << endl;
	}
    }
}


int main(int argc, char** argv)
{
    TMushMessageQueue* MessageQueue = 0;

    try {
	if ((argc > 1) && (argv[1][1] == 's')) {
	    MessageQueue = new TMushServerMessageQueue(ProjectID);
	    cout << "MessageQueue Created: ";
	    cout << "capacity=" << MessageQueue->QueueCapacity() << endl;
	    WorkAsServer(MessageQueue);
	}
	else if ((argc > 1) && (argv[1][1] == 'c')) {
	    MessageQueue = new TMushClientMessageQueue(ProjectID);
	    WorkAsClient(MessageQueue);
	}
	else {
	    cerr << "usage: " << endl;
	    cerr << "  as server:" << argv[0] << " -s" << endl;
	    cerr << "  as client:" << argv[0] << " -c" << endl;
	    cerr << "* Server process (" << argv[0] << " -s) must be ";
	    cerr << "launched before client process is launched." << endl; 
	    cerr << "* More than one client processes can be launched ";
	    cerr << "at the same time." << endl;
	}
    }
    catch (TSystemCallException e) {
	cerr << e << endl;
    }
    cout << endl;

    delete MessageQueue;

    return 0;
}
