/* misc-test.cc */
/* Created by Enomoto Sanshiro on 5 May 2000. */
/* Last updated by Enomoto Sanshiro on 5 May 2000. */


#include <iostream>
#include <string>
#include "MushMisc.hh"

using namespace std;


int main(void)
{
    TMushDateTime Date;
    cout << "date: " << Date.AsString();
    cout << " (" << Date.AsLong() << " seconds from 1 Jan 1770)" << endl;

    TMushLocalHost Host;
    cout << "host: " << Host.HostName();
    cout << " (" << Host.Machine() << ", ";
    cout << Host.SystemName() << " ";
    cout << Host.SystemRelease() << ")" << endl;

    TMushCpu Cpu;
    cout << "cpu: " << (Cpu.IsLittleEndian() ? "little" : "big") << " endian" << endl;

    TMushUser User;
    cout << "user: " << User.Name();
    cout << " (id " << User.Id() << ", ";
    cout << "group " << User.GroupName() << ", ";
    cout << "home " << User.HomeDirectory() << ")" << endl;

    if (TMushEnvironmentVariable::IsDefined("DISPLAY")) {
	string Display = TMushEnvironmentVariable("DISPLAY").AsString();
	cout << "display: " << Display << endl;
    }
    else {
	cout << "environmental variable 'DISPLAY' is not defined." << endl;
    }

    map<string, string> Table;
    TMushEnvironmentVariable::LoadTable(Table);

    return 0;
}
