/* process-test.cc */
/* Created by Enomoto Sanshiro on 5 May 2000. */
/* Last updated by Enomoto Sanshiro on 5 May 2000. */


#include <iostream>
#include <string>
#include <vector>
#include "MushProcess.hh"

using namespace std;


int main(void)
{
    // If the following Path string starts with '/', TMushChildProcess
    // will check whether the file exists and is executable,
    // in prior to call fork().
    string Path = "/usr/X11R6/bin/xterm";

    // The first argument is 'name', which corresponds to argv[0].
    vector<string> ArgumentList;
    ArgumentList.push_back("xterm");
    ArgumentList.push_back("-e");
    ArgumentList.push_back("vi");

    TMushChildProcess Process(Path, ArgumentList);

    try {
	Process.Run();
	Process.WaitToExit();
    }
    catch (TSystemCallException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }

    return 0;
}
