/* signal-test.cc */
/* Created by Enomoto Sanshiro on 5 May 2000. */
/* Last updated by Enomoto Sanshiro on 5 May 2000. */


#include <iostream>
#include "MushSignal.hh"
#include "MushTimer.hh"

using namespace std;


class TMySignalClient: public TMushSignalClient {
  public:
    TMySignalClient(void) {}
    virtual ~TMySignalClient() {}
    virtual void OnCatchSignal(int SignalID) {
	cout << "oops!" << endl;
    }
};


int main(void)
{
    TMushSignalHandler SignalHandler;
    TMySignalClient MySignalClient;
    TMushSignalCounter ExitSignalCounter;

    SignalHandler.RegisterClient(SIGINT, &MySignalClient);
    SignalHandler.RegisterClient(SIGTERM, &ExitSignalCounter);
    SignalHandler.RegisterClient(SIGQUIT, &ExitSignalCounter);
    SignalHandler.StartHandling();

    while (ExitSignalCounter.SignalCount() == 0) {
	SignalHandler.StartBlocking();
	cout << "start blocking..." << flush;

	TMushRealTimeTimer(3, 0).Suspend();

	cout << "end" << endl;
	SignalHandler.StopBlocking();
    }

    return 0;
}
