/* RoomNetworkAccess.hh */
/* Created by Enomoto Sanshiro on 16 July 2009. */
/* Last updated by Enomoto Sanshiro on 16 July 2009. */


#ifndef __RoomNetworkAccess_hh__
#define __RoomNetworkAccess_hh__


#include <string>
#include "RoomModule.hh"


class TRoomNetworkConnection {
  public:
    TRoomNetworkConnection(void);
    virtual ~TRoomNetworkConnection();
    virtual int Connect(const std::string& RemoteHostName, int PortNumber) throw(THardwareException);
    virtual bool Probe(void) throw(THardwareException);
    virtual int Send(const void* Data, size_t Size) throw(THardwareException);
    virtual int Receive(void* Data, size_t MaxSize) throw(THardwareException);
    virtual int SendBlock(const void* Data, size_t Size) throw(THardwareException);
    virtual int ReceiveBlock(void* Data, size_t Size) throw(THardwareException);
    virtual bool WaitArrival(int TimeOut_ms = 0) throw(THardwareException);
  private:
    int _Socket;
};


class TRoomNetworkModule: public TRoomModule, public TRoomNetworkConnection {
  public:
    TRoomNetworkModule(const std::string& ModuleType, const std::string& ModelName);
    virtual ~TRoomNetworkModule();
    virtual TRoomNetworkModule* Clone(void) = 0;
};


#endif
