/* RoomTkoAccess.cc */
/* Created by Enomoto Sanshiro on 17 July 1999. */
/* Last updated by Enomoto Sanshiro on 8 July 2001. */

// ***************************************** //
//  THIS CODE IS NOT MAINTAINED. DO NOT USE. //
// ***************************************** //


#include "RoomTkoAccess.hh"

using namespace std;


TRoomTkoController::TRoomTkoController(void) throw(THardwareException)
{
}

TRoomTkoController::~TRoomTkoController()
{
}



TRoomTkoCrate::TRoomTkoCrate(void)
{
    _TkoController = 0;
}

TRoomTkoCrate::TRoomTkoCrate(TRoomTkoController *Controller)
{
    _TkoController = Controller;
}

TRoomTkoCrate::~TRoomTkoCrate()
{
}

void TRoomTkoCrate::InstallController(TRoomTkoController *Controller)
{
    _TkoController = Controller;    
}

void TRoomTkoCrate::Install(TRoomTkoModule *TkoModule, int ModuleAddress) throw(THardwareException)
{
    if (_TkoController == 0) {
        throw THardwareException(
            "TRoomTkoCrate::Install()", "controller is not installed"
        );
    }

    TkoModule->Attach(this, ModuleAddress);
    _ModuleList.push_back(TkoModule);
}

void TRoomTkoCrate::Uninstall(TRoomTkoModule *TkoModule)
{
    TkoModule->Detach();
}

TRoomTkoController* TRoomTkoCrate::TkoController(void) const
{
    return _TkoController;
}



TRoomTkoModule::TRoomTkoModule(const string& ModuleType, const string& ModelName)
: TRoomModule(ModuleType, ModelName)
{
    _TkoCrate = 0;
    _TkoController = 0;
}

TRoomTkoModule::~TRoomTkoModule()
{
    if (_TkoCrate != 0) {
	_TkoCrate->Uninstall(this);
    }
}

int TRoomTkoModule::TkoAction(int Address, int Function, int &Data, int &Q) 
{
    _TkoController->TkoAction(_ModuleAddress, Address, Function, Data, Q);
    
    return Q;
}

int TRoomTkoModule::TkoAction(int Address, int Function, int &Data) throw(THardwareException)
{
    int Q;
    _TkoController->TkoAction(_ModuleAddress, Address, Function, Data, Q);

    return Q;
}

int TRoomTkoModule::TkoAction(int Address, int Function) throw(THardwareException)
{
    int Data;
    int Q;
    _TkoController->TkoAction(_ModuleAddress, Address, Function, Data, Q);

    return Q;
}

void TRoomTkoModule::Attach(TRoomTkoCrate* Crate, int ModuleAddress)
{
    _TkoCrate = Crate;
    _TkoController = Crate->TkoController();

    _ModuleAddress = ModuleAddress;
    _ModuleAddressBit = Bit(_ModuleAddress - 1);
}

void  TRoomTkoModule::Detach()
{
    _TkoCrate = 0;
    _TkoController = 0;
}
