/* RoomTkoAccess.hh */
/* Created by Enomoto Sanshiro on 17 July 1999. */
/* Last updated by Enomoto Sanshiro on 8 July 2001. */

// ***************************************** //
//  THIS CODE IS NOT MAINTAINED. DO NOT USE. //
// ***************************************** //


#ifndef __RoomTkoAccess_hh__
#define __RoomTkoAccess_hh__


#include <string>
#include <vector>
#include "RoomDefs.hh"
#include "RoomDeviceBase.hh"
#include "RoomModule.hh"


class TRoomTkoModule;

class TRoomTkoController: public TRoomController {
  public:
    TRoomTkoController(void) throw(THardwareException);
    virtual ~TRoomTkoController();
    virtual int TkoAction(int ModuleAddress, int Address, int Function, int &Data, int &Q) throw(THardwareException) = 0;
};


class TRoomTkoCrate: public TRoomCrate {
  public:
    TRoomTkoCrate(void);
    TRoomTkoCrate(TRoomTkoController *Controller);
    virtual ~TRoomTkoCrate();
    virtual void InstallController(TRoomTkoController *Controller);
    virtual void Install(TRoomTkoModule *TkoModule, int ModuleAddress) throw(THardwareException);
    virtual void Uninstall(TRoomTkoModule *TkoModule);
    virtual TRoomTkoController* TkoController(void) const;
  private:
    TRoomTkoController *_TkoController;
    std::vector<TRoomTkoModule*> _ModuleList;
};


class TRoomTkoModule: public TRoomModule {
  public:
    TRoomTkoModule(const std::string& ModuleType, const std::string& ModelName);
    virtual ~TRoomTkoModule();
    virtual TRoomTkoModule* Clone(void) = 0;
  public:
    int TkoAction(int Address, int Function, int &Data, int &Q);
    int TkoAction(int Address, int Function, int &Data) throw(THardwareException);
    int TkoAction(int Address, int Function) throw(THardwareException);
  private:
    friend class TRoomTkoCrate;
    void Attach(TRoomTkoCrate* Crate, int ModuleAddress);
    void Detach(void);
  protected:
    TRoomTkoController *_TkoController;
    TRoomTkoCrate *_TkoCrate;
    int _ModuleAddress;
    unsigned _ModuleAddressBit;
};


#endif
