/* module-Hoshin_V004.cc */
/* Created by Enomoto Sanshiro on 26 May 1997. */
/* Last updated by Enomoto Sanshiro on 20 October 2005. */


#include "RoomDeviceFactory.hh"
#include "RoomModule.hh"
#include "RoomVmeAccess.hh"
#include "module-Hoshin_V004.hh"

using namespace std;


static TRoomVmeModuleCreator Creator3(
    "Hoshin_V004", new TVmeScaler_Hoshin_V004()
);


TVmeScaler_Hoshin_V004::TVmeScaler_Hoshin_V004(void)
: TRoomVmeModule("VmeScaler", "Hoshin_V004", (TRoomVmeTransferMode) V004_TransferMode, (size_t) V004_MemorySize)
{
}

TVmeScaler_Hoshin_V004::~TVmeScaler_Hoshin_V004()
{
}

TRoomVmeModule* TVmeScaler_Hoshin_V004::Clone(void)
{
    return new TVmeScaler_Hoshin_V004();
}

int TVmeScaler_Hoshin_V004::Initialize(int InitialState) throw(THardwareException)
{
    Disable();
    Clear();

    return 0;
}

int TVmeScaler_Hoshin_V004::Read(int Address, int &Data) throw(THardwareException)
{
    if ((Address < 0) || (Address >= V004_NumberOfChannels)) {
	Data = 0;
	return 0;
    }

    Data = (WordAt(4*Address + 2) << 16) | WordAt(4*Address);
    Data &= V004_ValidBitMask;

    return 1;
}

int TVmeScaler_Hoshin_V004::Enable(int Address) throw(THardwareException)
{
    WordAt(regStart) = 0;

    return 0;
}

int TVmeScaler_Hoshin_V004::Disable(int Address) throw(THardwareException)
{
    WordAt(regStop) = 0;
    
    return 0;
}

int TVmeScaler_Hoshin_V004::Clear(int Address) throw(THardwareException)
{
    WordAt(regReset) = 0;
    
    return 0;
}

int TVmeScaler_Hoshin_V004::NumberOfChannels(void) throw(THardwareException)
{
    return V004_NumberOfChannels;
}
