/* module-LeCroy_2277.cc */
/* Created by Enomoto Sanshiro on 19 April 2002. */
/* Last updated by Enomoto Sanshiro on 19 April 2002. */


// **************************************** //
// * THIS CODE IS NOT TESTED. DO NOT USE. * //
// **************************************** //


#include <string>
#include "RoomModule.hh"
#include "RoomCamacAccess.hh"
#include "RoomDeviceFactory.hh"
#include "module-LeCroy_2277.hh"


static TRoomCamacModuleCreator Creator(
    "LeCroy_2277", new TCamacTDC_LeCroy_2277()
);


TCamacTDC_LeCroy_2277::TCamacTDC_LeCroy_2277()
: TRoomCamacModule("CamacMultihitTDC", "LeCroy_2277 (NOT TESTED)")
{
    _BufferSize = _NumberOfChannels * _NumberOfSamples;
    _Buffer = new U32bit[_BufferSize];

    _NumberOfData = -1;
}

TCamacTDC_LeCroy_2277::~TCamacTDC_LeCroy_2277()
{
    delete[] _Buffer;
}

TRoomCamacModule* TCamacTDC_LeCroy_2277::Clone(void)
{
    return new TCamacTDC_LeCroy_2277();
}

int TCamacTDC_LeCroy_2277::Clear(int Address) throw(THardwareException)
{
    TRoomCamacModule::Clear(Address);
    _NumberOfData = -1;

    return 1;
}

int TCamacTDC_LeCroy_2277::WriteRegister(int Address, int Data) throw(THardwareException)
{
    static const int fnWriteStatusRegister = 17;
    static const int adWriteStatusRegister = 0;

    return Transact(fnWriteStatusRegister, adWriteStatusRegister, Data);
}

int TCamacTDC_LeCroy_2277::ReadRegister(int Address, int& Data) throw(THardwareException)
{
    static const int fnReadStatusRegister = 1;
    static const int adReadStatusRegister = 0;

    return Transact(fnReadStatusRegister, adReadStatusRegister, Data);
}


// The Read() interface provides functions as a normal single hit TDC.
// second or later TDC hits are ignored, and edge polarity information 
// is thrown away.
int TCamacTDC_LeCroy_2277::Read(int Address, int &Data) throw(THardwareException)
{
    if (_NumberOfData < 0) {
	_NumberOfData = ReadDataBlockTo(_Buffer, _BufferSize);
    }

    for (int Index = 0; Index < _NumberOfData; Index++) {
	if (AddressOf(_Buffer[Index]) == Address) {
	    Data = DataOf(_Buffer[Index]);
	    return 1;
	}
    }

    return 0;
}

// The SequentialRead() interface provides functions as a multi-hit TDC. 
// Edge polarity information is thrown away.
int TCamacTDC_LeCroy_2277::SequentialRead(int Address, int Data[], int MaxSize) throw(THardwareException)
{
    if (_NumberOfData < 0) {
	_NumberOfData = ReadDataBlockTo(_Buffer, _BufferSize);
    }

    int DataCount = 0;
    for (int Index = 0; Index < _NumberOfData; Index++) {
	if (AddressOf(_Buffer[Index]) == Address) {
	    Data[DataCount++] = DataOf(_Buffer[Index]);
	    if (DataCount >= MaxSize) {
		break;
	    }
	}
    }

    return DataCount;
}

int TCamacTDC_LeCroy_2277::NextNumberOfDataElements(int Address) throw(THardwareException)
{
    // here we cannot know the exact data size until the data is actually read.
    // returns the maximum size.

    return _NumberOfSamples;
}

// The BlockRead() interface provides full functions of the device. 
// Since the data format is 'as-is', the taken data needs to be analyzed.
int TCamacTDC_LeCroy_2277::BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException)
{
    return sizeof(U32bit) * ReadDataBlockTo(Data, MaxSize);
}

int TCamacTDC_LeCroy_2277::NextDataBlockSize(int Address) throw(THardwareException)
{
    // here we cannot know the exact data size until the data is actually read.
    // returns the maximum size.

    return sizeof(U32bit) * _NumberOfChannels * _NumberOfSamples;
}

int TCamacTDC_LeCroy_2277::ReadDataBlockTo(void* Data, int MaxSize) throw(THardwareException)
{
    int DataCount = 0;
    int DataElement;

    while (1) {
	if (! Transact(fnRead, adAny, DataElement)) {
	    static const int fnTestBusy = 27;
	    static const int adTestBusy = 1;
	    if (Transact(fnTestBusy, adTestBusy)) {
		// FIFO is empty and the processor is not busy... 
		// i.e. data readout is completed.
		break;
	    }
	    else {
		// FIFO is empty but the processor is busy... 
		// wait for the processor to send next data.
		continue;
	    }
	}

	if ((int) sizeof(U32bit) * DataCount >= MaxSize) {
	    break;
	}

	((U32bit*) Data)[DataCount++] = DataElement;
    }

    return DataCount;
}
