/* module-RawFile.hh */
/* Created by Enomoto Sanshiro on 25 August 2009. */
/* Last updated by Enomoto Sanshiro on 25 August 2009. */


#ifndef __module_RawFile_hh__
#define __module_RawFile_hh__


#include <string>
#include "RoomDefs.hh"
#include "RoomModule.hh"
#include "RoomSoftwareDevice.hh"


class TSoftwareModule_RawFile: public TRoomSoftwareModule {
  public:
    TSoftwareModule_RawFile(void);
    virtual ~TSoftwareModule_RawFile();
    virtual TRoomSoftwareModule* Clone(void);
    virtual bool ProcessCommand(const std::string& Command, const std::vector<std::string>& ArgumentList) throw(THardwareException);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Finalize(int FinalState = 0) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual bool HasData(int Address = -1) throw(THardwareException);
    virtual bool WaitData(unsigned TimeOut_sec = 1) throw(THardwareException);
    virtual int NextDataBlockSize(int Address = -1) throw(THardwareException);
    virtual int BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException);
  protected:
    std::string _FileName;
    int _File;
    int _BlockSize;
    bool _IsEnd;
};


#endif

