/* module-Rinei_RPC360.hh */
/* Created by Enomoto Sanshiro on 19 February 2002. */
/* Last updated by Enomoto Sanshiro on 19 February 2002. */


#ifndef __module_Rinei_RPC360_hh__
#define __module_Rinei_RPC360_hh__


#include <string>
#include "RoomModule.hh"
#include "RoomCamacAccess.hh"


/* CMS Multi Cast Model RPC-360 (Rinei) */
class TCamacMisc_Rinei_RPC360: public TRoomCamacModule {
  public:
    TCamacMisc_Rinei_RPC360(void);
    virtual ~TCamacMisc_Rinei_RPC360();
    virtual TRoomCamacModule* Clone(void);
   public:
    virtual int EnableLam(void) throw(THardwareException);
    virtual int DisableLam(void) throw(THardwareException);
    virtual int ClearLam(void) throw(THardwareException);
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
  public:
    enum TContolId {
	ControlId_ClearCounter,
	ControlId_StartCounter,
	ControlId_StopCounter,
	_NumberOfControls
    };
};


#endif
