/* module-Rinei_RPV170.hh */
/* Created by Enomoto Sanshiro on 29 July 2003. */
/* Last updated by Enomoto Sanshiro on 29 July 2003. */


#ifndef __module_Rinei_RPV170_hh__
#define __module_Rinei_RPV170_hh__


#include "RoomVmeAccess.hh"


class TVmeQADC_Rinei_RPV170: public TRoomVmeModule {
  public:
    TVmeQADC_Rinei_RPV170(void);
    virtual ~TVmeQADC_Rinei_RPV170();
    virtual TRoomVmeModule* Clone(void);
  public:
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Finalize(int FinalState = 0) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual bool HasData(int Address = -1) throw(THardwareException);
    virtual bool WaitData(unsigned TimeOut_sec = 1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int NextDataBlockSize(int Address = -1) throw(THardwareException);
    virtual int BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException);
    virtual int NumberOfChannels(void) throw(THardwareException);
    virtual int AddressBitLength(void);
    virtual int DataBitLength(void);
  public:
    virtual bool IsSignalOnServiceRequestAvailable(void);
    virtual void ClearServiceRequest(void) throw(THardwareException);
  public:
    enum TRPV170_Parameters {
	RPV170_TransferMode = VmeTransferMode_A32D16,
	RPV170_MapSize = 0x1000,
	RPV170_NumberOfChannels = 16,
	RPV170_DataBlockSize = 0x20,
	RPV170_AddressBitLength = 4,
	RPV170_DataBitLength = 12,
	_NumberOfParameters
    };
    enum TRPV170_Registers {
	regFlag = 0x21000,
	    bitFlag_HIT = (0x0001 << 0),
	    bitFlag_BUSY = (0x0001 << 1),
	    bitFlag_DONE = (0x0001 << 2),
	regClear = 0x21002,
	    bitClear_CLR = (0x0001 << 0),
	_NumberOfRegisters
    };
};


#endif
