/* module-SIS_3801.hh */
/* Created by Glenn H-S. on 31 Aug 2000. */
/* Last updated by Enomoto Sanshiro on 9 August 2002. */


#ifndef __SIS_3801_hh__
#define __SIS_3801_hh__


#include "RoomDefs.hh"
#include "RoomModule.hh"
#include "RoomVmeAccess.hh"


class TVmeScaler_SIS_3801: public TRoomVmeModule {
  public:
    TVmeScaler_SIS_3801();
    virtual ~TVmeScaler_SIS_3801();
    virtual TRoomVmeModule* Clone(void);
  public:
    virtual bool Probe(void) throw(THardwareException);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException);
    virtual int NextDataBlockSize(int Address = -1) throw(THardwareException);
    virtual int ReadRegister(int Address, int& Data) throw(THardwareException);
    virtual int WriteRegister(int Address, int Data) throw(THardwareException);
  private:
    volatile DoubleWord _DummyVariableToAvoidCompilerOptimization;
  private:
    enum internal_parameters_e {
        SIS3801_TransferMode = VmeTransferMode_A32D32,
	SIS3801_MapSize = 0x1000,
	SIS3801_BoardId = 0x3801
    };
    enum constant_e { 
        FifoSize = 4 * 32 * 1024,
	FifoWindowSize = 256
    };
    enum registers_e {
	regCSR = 0x000,
	regIdIrq = 0x004,
	regCopyDisable = 0x00C,
	regClearFifo = 0x020,
	regVmeNext = 0x024,
	regEnableNextClock = 0x028,
	regDisableNextClock = 0x02c,
	regRefPulserCh1Enable = 0x050,
	regRefPulserCh1Disable = 0x054,
	regReset = 0x060,
	regSoftTestPulse = 0x068,
	regFifoRead = 0x100,
	_NumberOfRegisters
    };
    enum bitmasks_e {
	bitUserLED         = 1<<0,
	bitFifoTest        = 1<<1,
	bitInpModeB0       = 1<<2,
	bitInpModeB1       = 1<<3,
	bit25MHzPuls       = 1<<4,
	bitInputTest       = 1<<5,
	bit10MHzLNEPre     = 1<<6,
	bitLNEPreEna       = 1<<7,
	bitFifoEmpty       = 1<<8,
	bitFifoAlmostEmpty = 1<<9,
	bitFifoHalfFull    = 1<<10,
	bitFifoAlmostFull  = 1<<11,
	bitFifoFull        = 1<<12,
	bitRefPulserCh1    = 1<<13,
	bitNextEna         = 1<<15,
	bitExtNextEna      = 1<<16,
	bitExtClearEna     = 1<<17,
	bitExtDisableEna   = 1<<18,
	bitSoftDisableEna  = 1<<19
    };
};


#endif 
