/* module-TrueTime_VMESG2.hh */
/* Created by Dennis Murphree on 18 Jan 2001. */
/* Last updated by Enomoto Sanshiro on 14 January 2002. */


#ifndef __TrueTime_VMESG2_hh__
#define __TrueTime_VMESG2_hh__


#include "RoomDefs.hh"
#include "RoomModule.hh"
#include "RoomVmeAccess.hh"


class TVmeTimingGenerator_TrueTime_VMESG2: public TRoomVmeModule {
  public:
    TVmeTimingGenerator_TrueTime_VMESG2(void);
    virtual ~TVmeTimingGenerator_TrueTime_VMESG2();
    virtual TRoomVmeModule* Clone(void);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Finalize(int FinalState = 0) throw(THardwareException);
    virtual int Enable(int Address = -1) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int Disable(int Address = -1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int ReadRegister(int Address, int& Data) throw(THardwareException);
    virtual int WriteRegister(int Address, int Data) throw(THardwareException);
    virtual int EnableInterrupt(int SignalId = 0) throw(THardwareException);
    virtual int DisableInterrupt(void) throw(THardwareException);
    virtual int ClearInterrupt(void) throw(THardwareException);
  public:
    virtual void EnableServiceRequest(void) throw(THardwareException);
    virtual void DisableServiceRequest(void) throw(THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
    virtual bool IsRequestingService(void) throw(THardwareException);
  public:
    virtual void FreezeTime(void);
    virtual void ReleaseTime(void);
    virtual int ReadMicroSeconds(void);
    virtual int ReadMilliSeconds(void);
    virtual int ReadSeconds(void);
    virtual int ReadMinutes(void);
    virtual int ReadHours(void);
    virtual int ReadDays(void);
    virtual int ReadYears(void);
    virtual int ReadStatus(void);
  public:
    virtual void EnableExtEventInterrupt(int Irq, int Vector);
    virtual void DisableExtEventInterrupt(void);
    virtual void ClearExtEventInterrupt(void);
    virtual bool IsExtEventTimeFrozen(void);
    virtual void ReleaseExtEventTime(void);
    virtual int ReadExtEventMicroSeconds(void);
    virtual int ReadExtEventMilliSeconds(void);
    virtual int ReadExtEventSeconds(void);
    virtual int ReadExtEventMinutes(void);
    virtual int ReadExtEventHours(void);
    virtual int ReadExtEventDays(void);
    virtual int ReadExtEventYears(void);
    virtual int ReadExtEventStatus(void);
  private:
    volatile int _DummyVariableToAvoidCompilerOptimization;
  private:
    enum TParameter {
	MapSize_TrueTime_VMESG2 = 0x1000,
	TransferMode_TrueTime_VMESG2 = VmeTransferMode_A16D16,
	OperationMode_Generator = 0x00,
	OperationMode_GpsSyncronized = 0x01,
	OperationMode_CodeSyncronized = 0x02
    };
    enum TReg_ister {
	reg_Config1 = 0xa0,
	reg_Config2 = 0xa2,
	reg_SelfTest = 0xde,
	reg_PositionMode = 0xa4,
	reg_CaptureTime = 0x40,
	reg_TimeWordOne = 0x42,
	reg_TimeWordTwo = 0x80,
	reg_TimeWordThree = 0x82,
	reg_TimeWordFour = 0x84,
	reg_TimeWordFive = 0x86,
	reg_ReleaseTime = 0x44, 
	reg_ExtEventTimeWordOne = 0x46,
	reg_ExtEventTimeWordTwo = 0x88,
	reg_ExtEventTimeWordThree = 0x8a,
	reg_ExtEventTimeWordFour = 0x8c,
	reg_ExtEventTimeWordFive = 0x8e,
	reg_ExtEventReleaseTime = 0x48,
	reg_InterruptControl0 = 0x00,
	reg_InterruptVector0 = 0x08
    };
    enum TBitShift {
	shift_UMicSecs = 0,
	shift_TMicSecs = 4,
	shift_HMicSecs = 8,
	shift_UMSecs = 12,
	shift_TMSecs = 0,
	shift_HMSecs = 4,
	shift_USecs = 8,
	shift_TSecs = 12,
	shift_UMins = 0,
	shift_TMins = 4,
	shift_UHours = 8,
	shift_THours = 12,
	shift_UDays = 0,
	shift_TDays = 4,
	shift_HDays = 8,
	shift_Status = 12,
	shift_UYears = 0,
	shift_TYears = 4,
	shift_HYears = 8,
	shift_ThYears = 12
    };
    enum TBit {
	bit_InterruptEnable = 0x10,
	bit_InterruptFlagAutoClear = 0x40,
	bit_InterruptFlag = 0x80,
        bit_InterruptEnableOnConfigRegister = 0x80,
        bit_IRIGB_Format_DC = 0x08
    };
};


#endif 
