/* ccnet-remote-raw-test.cc */
/* Created by Enomoto Sanshiro on 13 January 2010. */
/* Last updated by Enomoto Sanshiro on 13 January 2010. */


#include <iostream>
#include <cstdlib>
#include "RoomNetworkAccess.hh"
#include "bridge-Toyo_CCNET.hh"

using namespace std;

static const string HostName = "ccnet";
static const int PortNumber = 2003;
static const int StationNumber = 4;

int main(int argc, char** argv)
{
    TRoomNetworkConnection NetworkConnection;
    TMiscDevice_Toyo_CCNET CCNET(&NetworkConnection);
    
    try {
	NetworkConnection.Connect(HostName, PortNumber);

	CCNET.CCNET_Open();
	CCNET.CCNET_Reset();

	int LamPattern = CCNET.CCNET_WaitLam(0x00ffffff);
	if (LamPattern != 0) {
	    cout << "LAM Handled. Pattern: " << LamPattern << endl;

	    int A = 0, F = 0, Data, Q, X;
	    CCNET.CCNET_ExecuteSingleCamac(StationNumber, A, F, Data, Q, X);
	    cout << Data << " " << Q << " " << X << endl;
	}

	CCNET.CCNET_Close();
    }
    catch (THardwareException &e) {
        cerr << "ERROR: " << e << endl;
	return -1;
    }

    return 0;
}
