/* intrtest.cc */
/* Created by Enomoto Sanshiro on 11 October 1997. */


#include <iostream>
#include <string>
#include <signal.h>
#include "RoomVmeAccess.hh"
#include "RoomDeviceFactory.hh"

using namespace std;


static const char* ModuleName = "Rinei_RPV130";
static const unsigned BaseAddress = 0x8000;
static const int IRQ = 3;
static const unsigned Vector = 0xfff0;


int main(void)
{
    TRoomDeviceFactory* DeviceFactory = TRoomDeviceFactory::GetInstance();

    TRoomVmeController* VmeController = DeviceFactory->CreateVmeController();
    TRoomVmeCrate* VmeCrate = DeviceFactory->CreateVmeCrate();
    TRoomVmeModule* IORegister = DeviceFactory->CreateVmeModule(ModuleName);

    VmeCrate->InstallController(VmeController);
    VmeCrate->Install(IORegister, BaseAddress, IRQ, Vector);
    IORegister->Initialize();

    IORegister->EnableInterrupt(SIGPOLL);

    cout << "Press <ENTER> to exit." << flush;
    string Line;
    getline(cin, Line);

    IORegister->DisableInterrupt();

    delete IORegister;
    delete VmeCrate;
    delete VmeController;

    return 0;
}
