/* rinei-rpv130-test.cc */
/* Created by Enomoto Sanshiro on 11 October 1997. */


#include "RoomVmeAccess.hh"
#include "RoomDeviceFactory.hh"
#include "module-Rinei_RPV130.hh"

using namespace std;

static const unsigned BaseAddress = 0x8000;
static const int IRQ = 3;
static const unsigned Vector = 0xfff0;


int main(void)
{
    TRoomDeviceFactory* DeviceFactory = TRoomDeviceFactory::GetInstance();

    TRoomVmeController* VmeController = DeviceFactory->CreateVmeController();
    TRoomVmeCrate* VmeCrate = DeviceFactory->CreateVmeCrate();
    TVmeIORegister_Rinei_RPV130* IORegister = new TVmeIORegister_Rinei_RPV130();

    VmeCrate->InstallController(VmeController);
    VmeCrate->Install(IORegister, BaseAddress, IRQ, Vector);

    IORegister->Initialize();

    IORegister->OutputPulse(Bit(3));

    IORegister->Finalize();

    delete IORegister;
    delete VmeCrate;
    delete VmeController;

    return 0;
}
