/* KinokoCompositeDataProcessor.hh */
/* Created by Enomoto Sanshiro on 14 December 2002. */
/* Last updated by Enomoto Sanshiro on 21 September 2004. */


#ifndef __KinokoCompositeDataProcessor_hh__
#define __KinokoCompositeDataProcessor_hh__


#include <string>
#include <vector>
#include "KinokoDataProcessor.hh"


class TKinokoCompositeDataProcessor: public TKinokoDataProcessor {
  public:
    TKinokoCompositeDataProcessor(void);
    virtual ~TKinokoCompositeDataProcessor();
    virtual void AddDataProcessor(const std::string& Name, int DataSourceId, TKinokoDataProcessor* DataProcessor);
    virtual void Destroy(void);
  public:
    virtual void AttachPlatform(std::istream& InputIoStream, std::ostream& OutputIoStream, TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry, TKinokoLogger* Logger);
    virtual void Construct(const std::string& Name, TKinokoInputStream* InputStream, TKinokoOutputStream* OutputStream, int DataSourceId) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual void ProcessPacket(void* DataPacket, long PacketSize) throw(TKinokoException);
  protected:
    virtual void BuildDataSource(TKinokoDataSource* DataSource);
  protected:
    int _ProcessorListSize;
    int _ProcessorListCapacity;
    std::vector<int> _DataSourceIdList;
    std::vector<std::string> _NameList;
    TKinokoDataProcessor** _ProcessorList;
};


#endif
