/* KinokoDataDumper.hh */
/* Created by Enomoto Sanshiro on 6 May 2001. */
/* Last updated by Enomoto Sanshiro on 6 May 2001. */


#ifndef __KinokoDataDumper_hh__
#define __KinokoDataDumper_hh__


#include <iostream>
#include <vector>
#include <set>
#include "KinokoDataSource.hh"
#include "KinokoDataSection.hh"
#include "KinokoDataAnalyzer.hh"
#include "KinokoIndexedDataSection.hh"
#include "KinokoBlockDataSection.hh"
#include "KinokoTaggedDataSection.hh"
#include "KinokoNestedDataSection.hh"


class TKinokoDataDumper: public TKinokoDataAnalyzer {
  public:
    TKinokoDataDumper(std::ostream& OutputStream);
    virtual ~TKinokoDataDumper();
    virtual void AddTargetSection(const std::string& SectionName);
    virtual bool IsSharable(void);
  protected:
    virtual int ProcessIndexedData(void* DataPacket, TKinokoIndexedDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessTaggedData(void* DataPacket, TKinokoTaggedDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessBlockData(void* DataPacket, TKinokoBlockDataSection* DataSection) throw(TKinokoException);
  protected:
    std::ostream& _OutputStream;
    std::vector<std::string> _TargetSectionNameList;
    std::set<std::string> _TargetSectionSet;
};


class TKinokoPacketDumper: public TKinokoDataDumper {
  public:
    TKinokoPacketDumper(std::ostream& OutputStream);
    virtual ~TKinokoPacketDumper();
  protected:
    virtual int ProcessIndexedData(void* DataPacket, TKinokoIndexedDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessTaggedData(void* DataPacket, TKinokoTaggedDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessBlockData(void* DataPacket, TKinokoBlockDataSection* DataSection) throw(TKinokoException);
};


class TKinokoTextDataDumper: public TKinokoDataDumper {
  public:
    TKinokoTextDataDumper(std::ostream& OutputStream, int FormatVersion = 0);
    virtual ~TKinokoTextDataDumper();
    virtual int ProcessDataPacket(void* DataPacket, TKinokoDataSource* DataSource = 0, TKinokoDataSection* DataSection = 0) throw(TKinokoException);
    virtual int ProcessTrailerPacket(void* Packet, TKinokoDataSource* DataSource = 0) throw(TKinokoException);
    virtual int ProcessCommandPacket(void* Packet, TKinokoDataSource* DataSource = 0) throw(TKinokoException);
  protected:
    virtual int ProcessIndexedData(void* DataPacket, TKinokoIndexedDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessTaggedData(void* DataPacket, TKinokoTaggedDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessBlockData(void* DataPacket, TKinokoBlockDataSection* DataSection) throw(TKinokoException);
  protected:
    int _FormatVersion;
    int _NestCount;
};


class TKinokoDataTabler: public TKinokoDataAnalyzer {
  public:
    TKinokoDataTabler(std::ostream& OutputStream, int FormatVersion = 0);
    virtual ~TKinokoDataTabler();
    void AddTargetSection(const std::string& SectionName);
    virtual void ReadDataSource(TKinokoDataSource* DataSource) throw(TKinokoException);
    virtual int ProcessTrailerPacket(void* Packet, TKinokoDataSource* DataSource = 0) throw(TKinokoException);
    virtual int ProcessCommandPacket(void* Packet, TKinokoDataSource* DataSource = 0) throw(TKinokoException);
  protected:
    virtual int ProcessIndexedData(void* DataPacket, TKinokoIndexedDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessTaggedData(void* DataPacket, TKinokoTaggedDataSection* DataSection) throw(TKinokoException);
  protected:
    std::ostream& _OutputStream;
    int _FormatVersion;
    int _EventCount, _EventTime, _StartTime;
    std::vector<std::pair<int, std::string> > _FieldNameList;
    std::vector<std::pair<int, std::string> > _IndexedDataList;
    std::vector<std::pair<std::string, std::string> > _TaggedDataList;
    std::set<std::string> _TargetSectionSet;
    std::string _DataSourceName;
};


#endif
