/* KinokoDataStreamMonitor.cc */
/* Created by Enomoto Sanshiro on 18 May 2003. */
/* Last updated by Enomoto Sanshiro on 18 May 2003. */


#include "MushMisc.hh"
#include "KinokoDataStreamMonitor.hh"

using namespace std;


TKinokoDataStreamMonitor::TKinokoDataStreamMonitor(void)
{
    _ClearTime = TMushDateTime::SecSinceEpoch();
    _NumberOfProcessedPackets = 0;
    _ProcessedDataSize = 0;
}

TKinokoDataStreamMonitor::~TKinokoDataStreamMonitor()
{
}

void TKinokoDataStreamMonitor::ProcessPacket(void* DataPacket, long PacketSize)
{
    _NumberOfProcessedPackets++;
    _ProcessedDataSize += PacketSize;
}

void TKinokoDataStreamMonitor::Clear(void)
{
    _ClearTime = TMushDateTime::SecSinceEpoch();
    _NumberOfProcessedPackets = 0;
    _ProcessedDataSize = 0;
}

long TKinokoDataStreamMonitor::PassedTime(void)
{
    return TMushDateTime::SecSince(_ClearTime);
}

long TKinokoDataStreamMonitor::NumberOfProcessedPackets(void)
{
    return _NumberOfProcessedPackets;
}

long TKinokoDataStreamMonitor::ProcessedDataSize(void)
{
    return _ProcessedDataSize;
}
