/* KinokoHistogram2dWriter.cc */
/* Created by Enomoto Sanshiro on 13 January 2001. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#include <string>
#include "KameHistogram2d.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoHistogram2dWriter.hh"

using namespace std;


TKinokoHistogram2dWriter::TKinokoHistogram2dWriter(kame::TKameHistogram2d* Histogram, const string& SectionPathX, const TKinokoDataElementSpecifier& ElementSpecifierX, const string& SectionPathY, const TKinokoDataElementSpecifier& ElementSpecifierY)
{
    _Histogram = Histogram;
    _SectionPathX = SectionPathX;
    _SectionPathY = SectionPathY;
    _ElementSpecifierX = ElementSpecifierX;
    _ElementSpecifierY = ElementSpecifierY;

    _SectionIndexX = AddSection(SectionPathX);
    _SectionIndexY = AddSection(SectionPathY);

    _TargetName = "untitled";
}

TKinokoHistogram2dWriter::~TKinokoHistogram2dWriter()
{
}

void TKinokoHistogram2dWriter::Destroy(void)
{
}

void TKinokoHistogram2dWriter::Reset(void) throw(TKinokoException)
{
    _Histogram->Clear();
}

int TKinokoHistogram2dWriter::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    int NumberOfProcessedElements = 0;

    int Address; float Data;
    if (SectionData->SectionIndex() == _SectionIndexX) {
	while (SectionData->GetNextOf(_ElementSpecifierX, Address, Data)) {
	    _XDataList.push_back(Data);
	    NumberOfProcessedElements++;
	}
    }
    else if (SectionData->SectionIndex() == _SectionIndexY) {
	while (SectionData->GetNextOf(_ElementSpecifierY, Address, Data)) {
	    _YDataList.push_back(Data);
	    NumberOfProcessedElements++;
	}
    }

    return (NumberOfProcessedElements > 0) ? 1 : 0;
}

int TKinokoHistogram2dWriter::ProcessTrailer(int TrailerValue) throw(TKinokoException)
{
    unsigned NumberOfData;
    if ((NumberOfData = _XDataList.size()) == _YDataList.size()) {
	for (unsigned i = 0; i < NumberOfData; i++) {
	    _Histogram->Fill(_XDataList[i], _YDataList[i]);
	}
    }

    _XDataList.erase(_XDataList.begin(), _XDataList.end());
    _YDataList.erase(_YDataList.begin(), _YDataList.end());

    return 1;
}

void TKinokoHistogram2dWriter::SetTargetName(const std::string& Name)
{
    _TargetName = Name;
}

void TKinokoHistogram2dWriter::Dump(ostream& os, const string& Indent)
{
    os << Indent << "FillHistogram2d" << "\t" << _TargetName;
    os << ", \"" << _SectionPathX << "\", " << _ElementSpecifierX.AsString();
    os << ", \"" << _SectionPathY << "\", " << _ElementSpecifierY.AsString();
    os << endl;
}
