/* KinokoHistoryWriter.hh */
/* Created by Enomoto Sanshiro on 29 October 1999. */
/* Last updated by Enomoto Sanshiro on 29 September 2002. */


#ifndef __KinokoHistoryWriter_hh__
#define __KinokoHistoryWriter_hh__


#include <iostream>
#include <string>
#include "KameHistory.hh"
#include "KinokoSectionDataAnalyzer.hh"


class TKinokoHistoryWriter: public TKinokoSectionDataAnalyzer {
  public:
    TKinokoHistoryWriter(kame::TKameHistory* History, const std::string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier);
    virtual ~TKinokoHistoryWriter();
    virtual void Destroy(void);
    virtual void Reset(void) throw(TKinokoException);
    virtual void SetTargetName(const std::string& Name);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
  protected:
    kame::TKameHistory* _History;
    std::string _SectionPath;
    TKinokoDataElementSpecifier _ElementSpecifier;
    std::string _TargetName;
};


#endif
