/* KinokoTrendWriter.cc */
/* Created by Enomoto Sanshiro on 29 October 1999. */
/* Updated by Enomoto Sanshiro on 29 September 2002. */
/* Last updated by Enomoto Sanshiro on 13 February 2008. */


#include <iostream>
#include <string>
#include "KameTrend.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoTrendWriter.hh"

using namespace std;
using namespace kame;


TKinokoTrendWriter::TKinokoTrendWriter(TKameTrend* Trend, const string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier)
{
    _Trend = Trend;
    _SectionPath = SectionPath;
    _ElementSpecifier = ElementSpecifier;

    AddSection(SectionPath);

    _TargetName = "untitled";
    _RunBeginCounts = 0;
}

TKinokoTrendWriter::~TKinokoTrendWriter()
{
}

void TKinokoTrendWriter::Destroy(void)
{
}

void TKinokoTrendWriter::Reset(void) throw(TKinokoException)
{
    long ClearTime;
    if (_Trend->NumberOfPoints() > 0) {
	ClearTime = _Trend->TimeOf(_Trend->NumberOfPoints()-1);
    }
    else {
	ClearTime = _Trend->StartTime();
    }

    _Trend->Clear();
    
    if (ClearTime > 0) {
	_Trend->Start(ClearTime);
    }
}

int TKinokoTrendWriter::ProcessCommandPacket(void* Packet, TKinokoDataSource* DataSource) throw(TKinokoException)
{
    int CommandValue = TKinokoDataStreamScanner::CommandValueOf(Packet);
    if (CommandValue == TKinokoDataStreamScanner::Command_RunBegin) {
	if (_RunBeginCounts == 0) {
	    int EventTime = TKinokoDataStreamScanner::CommandTimeOf(Packet);
	    _Trend->Clear();
	    _Trend->Start(EventTime);
	}
	_RunBeginCounts++;
    }

    return TKinokoSectionDataAnalyzer::ProcessCommandPacket(Packet, DataSource);
}

int TKinokoTrendWriter::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    int NumberOfProcessedElements = 0;

    int Address; float Data;
    long TimeStamp = SectionData->GetEventTime();;
    while (SectionData->GetNextOf(_ElementSpecifier, Address, Data)) {
        _Trend->Fill(TimeStamp, Data);
	NumberOfProcessedElements++;
    }

    return (NumberOfProcessedElements > 0) ? 1 : 0;
}

void TKinokoTrendWriter::SetTargetName(const std::string& Name)
{
    _TargetName = Name;
}

void TKinokoTrendWriter::Dump(ostream& os, const string& Indent)
{
    os << Indent << "FillTrend" << "\t" << _TargetName;
    os << ", \"" << _SectionPath << "\", " << _ElementSpecifier.AsString();
    os << endl;
}
