/* KinokoWaveWriter.cc */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#include <string>
#include <algorithm>
#include "KameNtuple.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoWaveWriter.hh"

using namespace std;
using namespace kame;


TKinokoWaveWriter::TKinokoWaveWriter(TKameNtuple* Ntuple, const string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier)
{
    _Ntuple = Ntuple;
    _SectionPath = SectionPath;
    _ElementSpecifier = ElementSpecifier;

    AddSection(SectionPath);

    _TargetName = "untitled";
}

TKinokoWaveWriter::~TKinokoWaveWriter()
{
}

void TKinokoWaveWriter::Destroy(void)
{
}

void TKinokoWaveWriter::Reset(void) throw(TKinokoException)
{
    _Ntuple->Clear();
}

int TKinokoWaveWriter::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    int DataIndex = 0;
    int Address; float Data;

    while (SectionData->GetNextOf(_ElementSpecifier, Address, Data)) {
	(*_Ntuple)[DataIndex][0] += Data;
	(*_Ntuple)[DataIndex][1] += 1;
	DataIndex++;
    }

    return (DataIndex > 0) ? 1 : 0;
}

void TKinokoWaveWriter::SetTargetName(const std::string& Name)
{
    _TargetName = Name;
}

void TKinokoWaveWriter::Dump(ostream& os, const string& Indent)
{
    os << Indent << "FillWave" << "\t" << _TargetName;
    os << ", \"" << _SectionPath << "\", " << _ElementSpecifier.AsString();
    os << endl;
}
