/* KinokoWaveWriter.hh */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#ifndef __KinokoWaveWriter_hh__
#define __KinokoWaveWriter_hh__


#include <string>
#include <vector>
#include "KameNtuple.hh"
#include "KinokoSectionDataAnalyzer.hh"


class TKinokoWaveWriter: public TKinokoSectionDataAnalyzer {
  public:
    TKinokoWaveWriter(kame::TKameNtuple* Ntuple, const std::string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier);
    virtual ~TKinokoWaveWriter();
    virtual void Destroy(void);
    virtual void Reset(void) throw(TKinokoException);
    virtual void SetTargetName(const std::string& Name);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
  protected:
    kame::TKameNtuple* _Ntuple;
    std::string _SectionPath;
    TKinokoDataElementSpecifier _ElementSpecifier;
    std::string _TargetName;
};


#endif
