/* KinokoBufferLogger.cc */
/* Created by Enomoto Sanshiro on 8 January 2000. */
/* Last updated by Enomoto Sanshiro on 8 January 2000. */

#include <iostream>
#include <string>
#include "KinokoDefs.hh"
#include "MushMisc.hh"
#include "KinokoBufferLogger.hh"

using namespace std;


TKinokoBufferLogger::TKinokoBufferLogger(void)
{
}

TKinokoBufferLogger::~TKinokoBufferLogger()
{
}


TKinokoBufferStreamLogger::TKinokoBufferStreamLogger(ostream& os)
: _os(os)
{
}

TKinokoBufferStreamLogger::~TKinokoBufferStreamLogger()
{
}

int TKinokoBufferStreamLogger::Write(const string& Message, int MessageLevel) throw(TKinokoException)
{
    switch (MessageLevel) {
      case TKinokoBufferLogger::mlInformation:
	_os << "<I> "; break;
      case TKinokoBufferLogger::mlLog:
	_os << "<L> "; break;
      case TKinokoBufferLogger::mlWarning:
	_os << "<W> "; break;
      case TKinokoBufferLogger::mlError:
	_os << "<E> "; break;
      case TKinokoBufferLogger::mlPanic:
	_os << "<P> "; break;
      default:
	_os << "<?> "; break;
    }

    _os << TMushDateTime().AsString() << " " << Message << endl;

    return 1;
}



TKinokoPrescaledBufferLogger::TKinokoPrescaledBufferLogger(TKinokoBufferLogger* Logger, int Interval_sec)
{
    _Logger = Logger;
    _Interval_sec = Interval_sec;

    _LastLogTime = 0;
}

TKinokoPrescaledBufferLogger::~TKinokoPrescaledBufferLogger()
{
}

int TKinokoPrescaledBufferLogger::Write(const std::string& Message, int MessageLevel) throw(TKinokoException)
{
    if (TMushDateTime::SecSince(_LastLogTime) > _Interval_sec) {
	_LastLogTime = TMushDateTime::SecSinceEpoch();
	return _Logger->Write(Message, MessageLevel);
    }
    else {
	return 0;
    }
}
