/* KinokoBuilder.hh */
/* Created by Enomoto Sanshiro on 25 August 2009. */
/* Updated by Enomoto Sanshiro on 19 May 2010. */
/* Last updated by Enomoto Sanshiro on 7 July 2010. */


#ifndef __KinokoBuilder_hh__
#define __KinokoBuilder_hh__


#include <string>
#include <iostream>
#include <vector>
#include "KinokoArena.hh"
#include "KinokoDataProcessor.hh"
#include "KinokoEventSorter.hh"
#include "KinokoEventEnvelope.hh"
#include "KinokoSorterController.hh"
#include "KinokoBuilderMonitor.hh"


class TKinokoBuilder: public TKinokoDataProcessor, protected TKinokoEventPieceDefs {
  public:
    TKinokoBuilder(void);
    virtual ~TKinokoBuilder();
    virtual void SetOutputDataSourceName(const std::string& DataSourceName);
    virtual void SetBufferSize(size_t BufferSize);
    virtual void SetBuilderLogger(TKinokoBuilderLogger* Logger);
    virtual void SetBuilderMonitor(TKinokoBuilderMonitor* Monitor);
    virtual void SetStartDataSize(size_t StartDataSize);
    virtual void SetStartPacketCycles(int NumberOfPacketCycles);
    virtual void SetStartChannelList(const std::vector<long>& ChannelList);
    virtual void SetInputPreservation(bool IsInputPreserved);
    virtual void SetActivityWindowLength(int WindowLength);
  public:
    // DataProcessor Interface //
    virtual void Construct(const std::string& Name, TKinokoInputStream* InputStream, TKinokoOutputStream* OutputStream, int DataSourceId) throw(TKinokoException);
  protected:
    // DataProcessor Interface //
    virtual void OnConstruct(void) throw(TKinokoException);
    virtual void OnDestruct(void) throw(TKinokoException);
    virtual void BuildDataSource(TKinokoDataSource* DataSource);
    virtual void OnRunBegin(void) throw(TKinokoException);
    virtual void OnRunEnd(void) throw(TKinokoException);
    virtual void OnReceivePacket(void* Packet, long PacketSize) throw(TKinokoException);
  protected:
    // Builder Interface //
    virtual TKinokoEventSorter& BuilderConstruct(void) throw(TKinokoException) = 0;
    virtual void BuilderBegin(void) throw(TKinokoException) = 0;
    virtual void BuilderEnd(void) throw(TKinokoException) = 0;
    virtual int BuilderProcess(void* Packet, long PacketSize) throw(TKinokoException) = 0;
  protected:
    char* _Buffer;
    size_t _BufferSize;
    TKinokoArena _Arena;
    TKinokoBuilderLogger* _Logger;
    TKinokoBuilderMonitor* _Monitor;
    TKinokoSorterController* _SorterController;
  protected:
    size_t _StartDataSize;
    int _StartPacketCycles;
    std::vector<long> _StartChannelList;
    bool _IsInputPreserved;
  protected:
    std::string _OutputDataSourceName;
    TKinokoEventEnvelopeWriter* _EnvelopeWriter;
  private:
    TKinokoBuilderMonitor* _MyMonitor;
};


#endif
