/* KinokoBuilderLogger.hh */
/* Created by Enomoto Sanshiro on 24 August 2009. */
/* Last updated by Enomoto Sanshiro on 24 August 2009. */


#ifndef __KinokoBuilderLogger_hh__
#define __KinokoBuilderLogger_hh__

#include <string>
#include <iostream>


class TKinokoBuilderLogger {
  public:
    enum TMessageLevel {
	mlInformation,   // no need to record
	mlLog,           // will be recorded
	mlWarning,       // may induce trouble
	mlError,         // need to be fixed, but run will go on
	mlPanic          // critical, run will be stopped immediately
    };
  public:
    TKinokoBuilderLogger(void) {}
    virtual ~TKinokoBuilderLogger() {}
    virtual int Write(const std::string& Message, int MessageLevel) = 0;
  public:
    int WriteInformation(const std::string& Message);
    int WriteLog(const std::string& Message);
    int WriteWarning(const std::string& Message);
    int WriteError(const std::string& Message);
    int WritePanic(const std::string& Message);
};


class TKinokoBuilderOstreamLogger: public TKinokoBuilderLogger {
  public:
    TKinokoBuilderOstreamLogger(std::ostream& Output);
    virtual ~TKinokoBuilderOstreamLogger();
    virtual int Write(const std::string& Message, int MessageLevel);
  protected:
    std::ostream& _Output;
};


class TKinokoBuilderNullLogger: public TKinokoBuilderLogger {
  public:
    TKinokoBuilderNullLogger(void);
    virtual ~TKinokoBuilderNullLogger();
    virtual int Write(const std::string& Message, int MessageLevel);
};


#endif
