/* KinokoBuilderProcessor.hh */
/* Created by Enomoto Sanshiro on 15 August 2009. */
/* Last updated by Enomoto Sanshiro on 7 March 2010. */


#ifndef __KinokoBuilderProcessor_hh__
#define __KinokoBuilderProcessor_hh__

#include <iostream>
#include "KinokoEventPiece.hh"
#include "KinokoEventSegment.hh"
#include "KinokoBuilderLogger.hh"


class TKinokoBuilderProcessor: protected TKinokoEventPieceDefs {
  public:
    TKinokoBuilderProcessor(void);
    virtual ~TKinokoBuilderProcessor();
    virtual void SetLogger(TKinokoBuilderLogger* Logger);
  public:
    virtual void ProcessRunBegin(void) {}
    virtual void ProcessRunEnd(void) {}
    virtual void ProcessEventBegin(TEventKey EventKey, int PieceType, int NumberOfPieces, size_t TotalSize) {}
    virtual void ProcessEventEnd(void) {}
  protected:
    TKinokoBuilderNullLogger* _NullLogger;
    TKinokoBuilderLogger* _Logger;
};


class TKinokoEventFragmentProcessor: public TKinokoBuilderProcessor {
  public:
    TKinokoEventFragmentProcessor(void) {}
    virtual ~TKinokoEventFragmentProcessor() {}
    virtual int ProcessFragment(TStreamKey StreamKey, const TKinokoDataChunk& DataChunk) = 0;
};


class TKinokoEventPieceProcessor: public TKinokoBuilderProcessor {
  public:
    TKinokoEventPieceProcessor(void) {}
    virtual ~TKinokoEventPieceProcessor() {}
    virtual int ProcessPiece(const TKinokoEventPiece& EventPiece) = 0;
};


class TKinokoEventSegmentProcessor: public TKinokoBuilderProcessor {
  public:
    TKinokoEventSegmentProcessor(void) {}
    virtual ~TKinokoEventSegmentProcessor() {}
    virtual int ProcessSegment(const TKinokoEventSegment& EventSegment) = 0;
};


#endif
