/* KinokoChannelWatcher.cc */
/* Created by Enomoto Sanshiro on 15 August 2009. */
/* Last updated by Enomoto Sanshiro on 20 June 2010. */


#include "KinokoChannelWatcher.hh"


int TKinokoChannelWatcher::_DefaultActivityWindowLength = 1000;


TKinokoChannelWatcher::TKinokoChannelWatcher(void)
{
    _ActivityWindowLength = _DefaultActivityWindowLength;

    _NumberOfEvents = 0;
    _NumberOfInvolved = 0;

    _IsAlive = true;
    _Occupancy = 0;
    _LengthOfAbsence = 0;

    _SuspensionCount = 0;
    _AbandonedCount = 0;
}

TKinokoChannelWatcher::~TKinokoChannelWatcher()
{
}

void TKinokoChannelWatcher::SetDefaultActivityWindowLength(int WindowLength)
{
    _DefaultActivityWindowLength = WindowLength;
}

void TKinokoChannelWatcher::AddInvolvedEvent(void)
{
    if (! _IsAlive) {
	// come back to alive //
	_IsAlive = true;
	_NumberOfEvents = 0;
	_NumberOfInvolved = 0;
	UpdateOccupancy();
    }

    if (_NumberOfEvents > _ActivityWindowLength) {
	UpdateOccupancy();
    }
    
    _NumberOfEvents++;
    _NumberOfInvolved++;
    _LengthOfAbsence = 0;
}	

void TKinokoChannelWatcher::AddAbsentEvent(void)
{
    if (_NumberOfEvents > _ActivityWindowLength) {
	UpdateOccupancy();
    }

    _NumberOfEvents++;
    _LengthOfAbsence++;
}

void TKinokoChannelWatcher::AddAbandonedEvent(void)
{
    _AbandonedCount++;

    if (_IsAlive) {
	_IsAlive = false;
	_SuspensionCount++;
    }
}

void TKinokoChannelWatcher::UpdateOccupancy(void)
{
    if (_NumberOfEvents == 0) {
	_Occupancy = 0;
    }
    else {
	_Occupancy = (float) _NumberOfInvolved / _NumberOfEvents;
    }
    
    _NumberOfEvents = 0;
    _NumberOfInvolved = 0;
}
