/* KinokoEventDumper.cc */
/* Created by Enomoto Sanshiro on 15 August 2009. */
/* Last updated by Enomoto Sanshiro on 7 March 2010. */


#include <iostream>
#include "KinokoDataChunk.hh"
#include "KinokoEventDumper.hh"

using namespace std;


TKinokoEventPieceDumper::TKinokoEventPieceDumper(std::ostream& Output)
: _Output(Output)
{
}

TKinokoEventPieceDumper::~TKinokoEventPieceDumper()
{
}

void TKinokoEventPieceDumper::ProcessEventBegin(TEventKey EventKey, int PieceType, int NumberOfPieces, size_t TotalSize)
{    
    _Output << "Event " << EventKey << ": ";

    static TEventKey PrevEventKey = 0;
    _Output << "(" << (EventKey - PrevEventKey) << ") ";
    if (PieceType == 1) {
	PrevEventKey = EventKey;
    }

    _Output << "type=" << PieceType;
    if (NumberOfPieces > 0) {
	_Output << ", n=" << NumberOfPieces;
	if (TotalSize > 0) {
	    _Output << ", size=" << TotalSize;
	}
    }
    _Output << ": " << flush;
}

void TKinokoEventPieceDumper::ProcessEventEnd(void) 
{
    _Output << endl;
}

int TKinokoEventPieceDumper::ProcessPiece(const TKinokoEventPiece& EventPiece)
{
    _Output << " " << EventPiece.ChannelKey;

    if (EventPiece.PieceType == PieceType_Normal) {
	;
    }
    else if (EventPiece.PieceType == PieceType_Padding) {
	_Output << "[P]";
    }
    else if (EventPiece.PieceType == PieceType_Unaligned) {
	_Output << "[U]";
    }
    else if (EventPiece.PieceType == PieceType_Corrupted) {
	_Output << "[C]";
    }
    else {
	_Output << "[?]";
    }

    //_Output << "(" << EventPiece.Size() << ")";
    _Output << flush;

    return 1;
}
